/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.jupnp.transport.impl.osgi.DisableAuthenticationHttpContext;
import org.jupnp.transport.spi.ServletContainerAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceServletContainerAdapter
implements ServletContainerAdapter {
    private final Logger logger = LoggerFactory.getLogger(HttpServiceServletContainerAdapter.class);
    private static HttpServiceServletContainerAdapter instance = null;
    protected HttpService httpService;
    private BundleContext context;
    private String contextPath;

    private HttpServiceServletContainerAdapter(HttpService httpService, BundleContext context) {
        this.httpService = httpService;
        this.context = context;
    }

    public static synchronized HttpServiceServletContainerAdapter getInstance(HttpService httpService, BundleContext context) {
        if (instance == null) {
            instance = new HttpServiceServletContainerAdapter(httpService, context);
        }
        return instance;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
    }

    @Override
    public int addConnector(String host, int port) throws IOException {
        if (port == -1) {
            try {
                port = Integer.parseInt(this.context.getProperty("org.osgi.service.http.port"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }

    @Override
    public void registerServlet(String contextPath, Servlet servlet) {
        if (this.contextPath == null) {
            Properties params = new Properties();
            try {
                this.logger.info("Registering UPnP callback servlet as {}", (Object)contextPath);
                this.httpService.registerServlet(contextPath, servlet, (Dictionary)params, (HttpContext)new DisableAuthenticationHttpContext());
                this.contextPath = contextPath;
            }
            catch (IllegalStateException | ServletException | NamespaceException e) {
                this.logger.error("Failed to register UPnP servlet!", e);
            }
        }
    }

    @Override
    public void startIfNotRunning() {
    }

    @Override
    public void stopIfRunning() {
        if (this.contextPath != null) {
            this.httpService.unregister(this.contextPath);
            this.contextPath = null;
        }
    }
}

