/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking.models;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class Hotel {
    private static final AtomicInteger sequence = new AtomicInteger();
    private static Map<String, Hotel> hotels = new LinkedHashMap();
    public final String id = "" + sequence.getAndIncrement();
    @Max(value=50L)
    @NotNull
    public String name;
    @Max(value=100L)
    public String address;
    @NotNull
    @Max(value=40L)
    public String city;
    @NotNull
    @Min(value=2L)
    @Max(value=6L)
    public String state;
    @NotNull
    @Min(value=5L)
    @Max(value=6L)
    public String zip;
    @NotNull
    @Min(value=2L)
    @Max(value=40L)
    public String country;
    public BigDecimal price;

    private static void add(Hotel hotel) {
        hotels.put(hotel.id, hotel);
    }

    private Hotel(String name, String address, String city, String state, String zip, String country, BigDecimal price) {
        this.name = name;
        this.address = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.country = country;
        this.price = price;
    }

    public String toString() {
        return "Hotel(" + this.name + "," + this.address + "," + this.city + "," + this.zip + ")";
    }

    public static Hotel findById(String id) {
        return (Hotel)hotels.get(id);
    }

    public static List<Hotel> find(Pattern namePattern, Pattern cityPattern, int size, int page) {
        int skip = size * page;
        ArrayList<Hotel> found = new ArrayList<Hotel>();
        for (Hotel hotel : hotels.values()) {
            if (!namePattern.matcher(hotel.name).matches() && !cityPattern.matcher(hotel.city).matches() || skip-- > 0) continue;
            if (size-- <= 0) break;
            found.add(hotel);
        }
        return found;
    }

    static {
        Hotel.add((Hotel)new Hotel("Marriott Courtyard", "Tower Place, Buckhead", "Atlanta", "GA", "30305", "USA", new BigDecimal(120)));
        Hotel.add((Hotel)new Hotel("Doubletree", "Tower Place, Buckhead", "Atlanta", "GA", "30305", "USA", new BigDecimal(180)));
        Hotel.add((Hotel)new Hotel("Hotel Rouge", "1315 16th Street NW", "Washington", "DC", "20036", "USA", new BigDecimal(250)));
        Hotel.add((Hotel)new Hotel("70 Park Avenue Hotel", "70 Park Avenue", "NY", "NY", "NY", "USA", new BigDecimal(300)));
        Hotel.add((Hotel)new Hotel("Conrad Miami", "1395 Brickell Ave", "Miami", "FL", "33131", "USA", new BigDecimal(300)));
        Hotel.add((Hotel)new Hotel("Sea Horse Inn", "2106 N Clairemont Ave", "Eau Claire", "WI", "54703", "USA", new BigDecimal(80)));
        Hotel.add((Hotel)new Hotel("Super 8 Eau Claire Campus Area", "1151 W Macarthur Av", "Eau Claire", "WI", "54703", "USA", new BigDecimal(90)));
        Hotel.add((Hotel)new Hotel("Marriott Downtown", "55 Fourth Street", "San Francisco", "CA", "94103", "USA", new BigDecimal(160)));
        Hotel.add((Hotel)new Hotel("Hilton Diagonal Mar", "Passeig del Taulat 262-264", "Barcelona", "Catalunya", "08019", "Spain", new BigDecimal(200)));
        Hotel.add((Hotel)new Hotel("Hilton Tel Aviv", "Independence Park", "Tel Aviv", "", "63405", "Israel", new BigDecimal(210)));
        Hotel.add((Hotel)new Hotel("InterContinental Tokyo Bay", "Takeshiba Pier", "Tokyo", "", "105", "Japan", new BigDecimal(240)));
        Hotel.add((Hotel)new Hotel("Hotel Beaulac", "Esplanade L\u00e9opold-Robert 2", "Neuchatel", "", "2000", "Switzerland", new BigDecimal(130)));
        Hotel.add((Hotel)new Hotel("Conrad Treasury Place", "William & George Streets", "Brisbane", "QLD", "4001", "Australia", new BigDecimal(140)));
        Hotel.add((Hotel)new Hotel("Ritz Carlton", "1228 Sherbrooke St", "West Montreal", "Quebec", "H3G1H6", "Canada", new BigDecimal(230)));
        Hotel.add((Hotel)new Hotel("Ritz Carlton", "Peachtree Rd, Buckhead", "Atlanta", "GA", "30326", "Atlanta", new BigDecimal(460)));
        Hotel.add((Hotel)new Hotel("Swissotel", "68 Market Street", "Sydney", "NSW", "2000", "Australia", new BigDecimal(220)));
        Hotel.add((Hotel)new Hotel("Meli\u00e1 White House", "Albany Street", "Regents Park London", "", "NW13UP", "Great Britain", new BigDecimal(250)));
        Hotel.add((Hotel)new Hotel("Hotel Allegro", "171 West Randolph Street", "Chicago", "IL", "60601", "USA", new BigDecimal(210)));
    }
}

