/*
 * Decompiled with CFR 0.152.
 */
package org.sample.booking;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.sample.booking.AbstractBookingTestCase;

public class AuthenticationTestCase
extends AbstractBookingTestCase {
    @Deployment
    public static WebArchive createDeployment() {
        return AbstractBookingTestCase.createDeployment();
    }

    @Test
    @InSequence(value=0)
    @RunAsClient
    public void login(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = deploymentURL.toURI().resolve("embed/BookingPortlet").toURL();
        this.driver.get(url.toString());
        WebElement loginForm = this.driver.findElement(By.className((String)"formLogin"));
        Assert.assertNotNull((Object)loginForm);
        loginForm.findElement(By.name((String)"username")).sendKeys(new CharSequence[]{"demo"});
        loginForm.findElement(By.name((String)"password")).sendKeys(new CharSequence[]{"demo"});
        loginForm.submit();
        WebElement messageBoard = this.driver.findElement(By.className((String)"fSuccess"));
        Assert.assertNotNull((Object)messageBoard);
        Assert.assertEquals((String)"Welcome, Demo User", (String)messageBoard.getText());
    }

    @Test
    @InSequence(value=1)
    @RunAsClient
    public void refreshAfterLogin(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = deploymentURL.toURI().resolve("embed/BookingPortlet").toURL();
        this.driver.get(url.toString());
        WebElement options = this.driver.findElement(By.className((String)"options"));
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((String)"Connected as demo | Search | Settings | Logout", (String)options.getText());
    }

    @Test
    @InSequence(value=2)
    @RunAsClient
    public void logout(@ArquillianResource URL deploymentURL) throws Exception {
        WebElement options = this.driver.findElement(By.className((String)"options"));
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((String)"Connected as demo | Search | Settings | Logout", (String)options.getText());
        WebElement logout = options.findElement(By.linkText((String)"Logout"));
        Assert.assertNotNull((Object)logout);
        Assert.assertEquals((String)"Logout", (String)logout.getText());
        this.driver.get(logout.getAttribute("href"));
        WebElement login = this.driver.findElement(By.className((String)"login"));
        Assert.assertNotNull((Object)login);
        Assert.assertTrue((boolean)login.getText().contains("(try with demo/demo)"));
        Assert.assertNotNull((Object)login.findElement(By.tagName((String)"form")));
    }

    @Test
    @InSequence(value=3)
    @RunAsClient
    public void refreshAfterLogout(@ArquillianResource URL deploymentURL) throws Exception {
        URL url = deploymentURL.toURI().resolve("embed/BookingPortlet").toURL();
        this.driver.get(url.toString());
        WebElement login = this.driver.findElement(By.className((String)"login"));
        Assert.assertNotNull((Object)login);
        Assert.assertTrue((boolean)login.getText().contains("(try with demo/demo)"));
        Assert.assertNotNull((Object)login.findElement(By.tagName((String)"form")));
    }
}

