/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.tools.SimpleJavaFileObject;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.FileManager;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileObjectImpl<P>
extends SimpleJavaFileObject {
    final FileKey key;
    final FileManager<P> manager;
    private P file;
    Content content;
    private boolean writing;

    public JavaFileObjectImpl(FileKey key, FileManager<P> manager, P file) {
        super(key.uri, key.kind);
        this.key = key;
        this.manager = manager;
        this.file = file;
        this.writing = false;
    }

    public FileKey getKey() {
        return this.key;
    }

    private Content getContent() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.file == null) {
            throw new FileNotFoundException("File " + this.key + " cannot be found");
        }
        if (this.content == null) {
            this.content = this.manager.fs.getContent(this.file);
        }
        return this.content;
    }

    public File getFile() throws IOException {
        return this.manager.fs.getFile(this.file);
    }

    @Override
    public long getLastModified() {
        try {
            return this.getContent().getLastModified();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.getContent().getCharSequence();
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        return this.getContent().getInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.manager.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.manager.fs;
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    JavaFileObjectImpl.this.content = new Content(System.currentTimeMillis(), this.toByteArray(), null);
                    Object file = fs.makeFile(JavaFileObjectImpl.this.key.packageNames, JavaFileObjectImpl.this.key.name);
                    fs.setContent(file, JavaFileObjectImpl.this.content);
                    JavaFileObjectImpl.this.file = file;
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public Writer openWriter() throws IOException {
        if (this.writing) {
            throw new IllegalStateException("Opened for writing");
        }
        if (this.manager.fs instanceof ReadWriteFileSystem) {
            final ReadWriteFileSystem fs = (ReadWriteFileSystem)this.manager.fs;
            return new StringWriter(){

                public void close() throws IOException {
                    JavaFileObjectImpl.this.content = new Content(System.currentTimeMillis(), this.getBuffer());
                    Object file = fs.makeFile(JavaFileObjectImpl.this.key.packageNames, JavaFileObjectImpl.this.key.name);
                    fs.setContent(file, JavaFileObjectImpl.this.content);
                    JavaFileObjectImpl.this.file = file;
                    JavaFileObjectImpl.this.writing = false;
                }
            };
        }
        throw new UnsupportedOperationException("Read only");
    }
}

