/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.juzu.AmbiguousResolutionException;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.cdi.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIManager
implements InjectManager<Bean<?>, CreationalContext<?>> {
    static final ThreadLocal<CDIManager> boot = new ThreadLocal();
    private BeanManager manager;
    final Map<Class<?>, Object> singletons;
    final ClassLoader classLoader;
    final Set<Class<?>> beans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDIManager(Container container, Map<Class<?>, Object> singletons, Set<Class<?>> beans) throws Exception {
        this.singletons = singletons;
        this.beans = beans;
        boot.set(this);
        try {
            container.start();
        }
        finally {
            boot.set(null);
        }
        this.classLoader = container.getClassLoader();
        this.manager = container.getManager();
    }

    @Override
    public String getImplementation() {
        return "cdi/weld";
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Bean<?> resolveBean(Class<?> type) {
        Set beans = this.manager.getBeans(type, new Annotation[0]);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + type + ": " + beans);
    }

    @Override
    public Bean<?> resolveBean(String name) {
        Set beans = this.manager.getBeans(name);
        switch (beans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Bean)beans.iterator().next();
            }
        }
        throw new AmbiguousResolutionException("Could not resolve bean of type " + name + ": " + beans);
    }

    @Override
    public CreationalContext<?> create(Bean<?> bean) {
        return this.manager.createCreationalContext(bean);
    }

    @Override
    public void release(CreationalContext<?> instance) {
        instance.release();
    }

    @Override
    public Object get(Bean<?> bean, CreationalContext<?> instance) {
        return this.manager.getReference(bean, (Type)bean.getBeanClass(), instance);
    }
}

