/*
 * Copyright (C) 2011 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.juzu.impl.spi.inject.spring;

import org.juzu.impl.inject.ScopeController;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public class SpringScope implements Scope
{

   private final org.juzu.impl.request.Scope scope;

   /** . */
   private final ScopeController controller;

   public SpringScope(org.juzu.impl.request.Scope scope, ScopeController controller)
   {
      this.scope = scope;
      this.controller = controller;
   }

   public Object get(String name, ObjectFactory<?> objectFactory)
   {
      Object o = controller.get(scope, name);
      if (o == null)
      {
         o = objectFactory.getObject();
         controller.put(scope, name, o);
      }
      return o;
   }

   public Object remove(String name)
   {
      throw new UnsupportedOperationException();
   }

   public void registerDestructionCallback(String name, Runnable callback)
   {
      throw new UnsupportedOperationException();
   }

   public Object resolveContextualObject(String key)
   {
      throw new UnsupportedOperationException();
   }

   public String getConversationId()
   {
      return "foo"; // ????
   }
}
