/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import org.juzu.impl.utils.IterableArray;
import org.juzu.impl.utils.Tools;

public class FileKey {
    public final Iterable<String> packageNames;
    public final Iterable<String> names;
    public final String packageFQN;
    public final String rawName;
    public final String fqn;
    public final String name;
    public final URI uri;
    public final JavaFileObject.Kind kind;

    public static FileKey newResourceName(String packageName, String name) throws IOException {
        return new FileKey(packageName, name, JavaFileObject.Kind.OTHER);
    }

    public static FileKey newJavaName(String className, JavaFileObject.Kind kind) throws IOException {
        if (kind == JavaFileObject.Kind.SOURCE || kind == JavaFileObject.Kind.CLASS) {
            int pos = className.lastIndexOf(46);
            if (pos == -1) {
                return new FileKey("", className, kind);
            }
            return new FileKey(className.substring(0, pos), className.substring(pos + 1), kind);
        }
        throw new IllegalArgumentException("Kind " + (Object)((Object)kind) + " not accepted");
    }

    public static FileKey newJavaName(String packageName, String name) throws IOException {
        JavaFileObject.Kind kind;
        if (name.endsWith(".java")) {
            kind = JavaFileObject.Kind.SOURCE;
        } else if (name.endsWith(".class")) {
            kind = JavaFileObject.Kind.CLASS;
        } else {
            throw new IllegalArgumentException("Illegal name " + name);
        }
        String rawName = name.substring(0, name.length() - kind.extension.length());
        return new FileKey(packageName, rawName, kind);
    }

    public static FileKey newName(String packageName, String name) throws IOException {
        JavaFileObject.Kind kind = name.endsWith(".java") ? JavaFileObject.Kind.SOURCE : (name.endsWith(".class") ? JavaFileObject.Kind.CLASS : JavaFileObject.Kind.OTHER);
        String rawName = name.substring(0, name.length() - kind.extension.length());
        return new FileKey(packageName, rawName, kind);
    }

    private FileKey(String packageFQN, String rawName, JavaFileObject.Kind kind) throws IOException {
        String fqn;
        String path;
        String name = rawName + kind.extension;
        if (packageFQN.length() == 0) {
            path = "/" + name;
            fqn = rawName;
        } else {
            path = "/" + packageFQN.replace('.', '/') + '/' + name;
            fqn = packageFQN + "." + rawName;
        }
        try {
            String[] abc = Tools.split(packageFQN, '.', 1);
            abc[abc.length - 1] = name;
            this.packageNames = new IterableArray<String>(abc, 0, abc.length - 1);
            this.names = new IterableArray<String>(abc, 0, abc.length);
            this.packageFQN = packageFQN;
            this.rawName = rawName;
            this.uri = new URI(path);
            this.fqn = fqn;
            this.kind = kind;
            this.name = name;
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not create path " + path, e);
        }
    }

    public FileKey as(JavaFileObject.Kind kind) throws IOException {
        return new FileKey(this.packageFQN, this.rawName, kind);
    }

    public final int hashCode() {
        return this.packageFQN.hashCode() ^ this.rawName.hashCode() ^ this.kind.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileKey) {
            FileKey that = (FileKey)obj;
            return this.packageFQN.equals(that.packageFQN) && this.rawName.equals(that.rawName) && this.kind.equals((Object)that.kind);
        }
        return false;
    }

    public String toString() {
        return "FileKey[packageName=" + this.packageFQN + ",rawName=" + this.rawName + ",kind=" + (Object)((Object)this.kind) + "]";
    }
}

