/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.resolver;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.juzu.Response;
import org.juzu.URLBuilder;
import org.juzu.impl.application.InternalApplicationContext;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.ControllerMetaModel;
import org.juzu.impl.model.meta.MetaModel;
import org.juzu.impl.model.meta.MetaModelEvent;
import org.juzu.impl.model.meta.MetaModelObject;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.meta.TemplateRefMetaModel;
import org.juzu.impl.model.processor.ModelHandler;
import org.juzu.impl.model.processor.ProcessingContext;
import org.juzu.impl.model.resolver.Template;
import org.juzu.impl.model.resolver.TemplateResolver;
import org.juzu.impl.spi.template.TemplateProvider;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.Tools;
import org.juzu.metadata.ApplicationDescriptor;
import org.juzu.metadata.ControllerDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.ControllerParameter;
import org.juzu.request.ActionContext;
import org.juzu.request.MimeContext;
import org.juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResolver
extends ModelHandler
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(ModelResolver.class);
    public static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile("([^/].*/|)([^./]+)\\.([a-zA-Z]+)");
    private static final Pattern PROVIDER_PKG_PATTERN = Pattern.compile("org\\.juzu\\.impl\\.spi\\.template\\.([^.]+)(?:\\..+)?");
    private static final String APPLICATION_DESCRIPTOR = ApplicationDescriptor.class.getSimpleName();
    private static final String CONTROLLER_METHOD = ControllerMethod.class.getSimpleName();
    private static final String CONTROLLER_DESCRIPTOR = ControllerDescriptor.class.getSimpleName();
    private static final String CONTROLLER_PARAMETER = ControllerParameter.class.getSimpleName();
    private static final String PHASE = Phase.class.getSimpleName();
    private static final String TOOLS = Tools.class.getSimpleName();
    private static final String RESPONSE = Response.Render.class.getSimpleName();
    ProcessingContext env;
    Map<String, TemplateProvider> providers;
    private Map<String, String> moduleConfig = new HashMap<String, String>();
    private Map<ElementHandle.Package, TemplateResolver> templateRepositoryMap;
    private MetaModel metaModel = new MetaModel();

    public ModelResolver() {
        this.templateRepositoryMap = new HashMap<ElementHandle.Package, TemplateResolver>();
    }

    @Override
    public void postActivate(ProcessingContext env) {
        ServiceLoader<TemplateProvider> loader = ServiceLoader.load(TemplateProvider.class, TemplateProvider.class.getClassLoader());
        HashMap<String, TemplateProvider> providers = new HashMap<String, TemplateProvider>();
        for (TemplateProvider provider : loader) {
            String pkgName = provider.getClass().getPackage().getName();
            Matcher matcher = PROVIDER_PKG_PATTERN.matcher(pkgName);
            if (!matcher.matches()) continue;
            String extension = matcher.group(1);
            providers.put(extension, provider);
        }
        this.env = env;
        this.providers = providers;
        this.metaModel.postActivate(env);
    }

    @Override
    public void processControllerMethod(ExecutableElement methodElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        this.metaModel.processControllerMethod(methodElt, annotationName, annotationValues);
    }

    @Override
    public void processDeclarationTemplate(VariableElement variableElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        this.metaModel.processDeclarationTemplate(variableElt, annotationName, annotationValues);
    }

    @Override
    public void processApplication(PackageElement packageElt, String annotationName, Map<String, Object> annotationValues) throws CompilationException {
        this.metaModel.processApplication(packageElt, annotationName, annotationValues);
    }

    @Override
    public void postProcess() throws CompilationException {
        log.log("Meta model post processing");
        this.metaModel.postProcess();
        for (MetaModelEvent event : this.metaModel.popEvents()) {
            log.log("Processing meta model event " + event.getType() + " " + event.getObject());
            this.processEvent(event);
        }
        log.log("Processing templates");
        this.processTemplates();
    }

    private void processEvent(MetaModelEvent event) throws CompilationException {
        MetaModelObject obj = event.getObject();
        switch (event.getType()) {
            case 0: {
                if (obj instanceof ApplicationMetaModel) {
                    ApplicationMetaModel application = (ApplicationMetaModel)obj;
                    this.moduleConfig.put(application.getFQN().getSimpleName(), application.getFQN().getFullName());
                    this.templateRepositoryMap.put(application.getHandle(), new TemplateResolver(application));
                    this.emitApplication(application);
                    break;
                }
                if (obj instanceof ControllerMetaModel) {
                    this.emitController((ControllerMetaModel)obj);
                    break;
                }
                if (obj instanceof TemplateMetaModel || obj instanceof TemplateRefMetaModel) break;
                throw new UnsupportedOperationException("Not yet supported add: " + obj);
            }
            case 1: {
                if (obj instanceof ApplicationMetaModel) {
                    throw new UnsupportedOperationException("Not yet supported remove: " + obj);
                }
                if (obj instanceof ControllerMetaModel || obj instanceof TemplateMetaModel || obj instanceof TemplateRefMetaModel) break;
                throw new UnsupportedOperationException("Not yet supported add: " + obj);
            }
            case 2: {
                if (obj instanceof ApplicationMetaModel) {
                    // empty if block
                }
                if (obj instanceof ControllerMetaModel) {
                    this.emitController((ControllerMetaModel)obj);
                    break;
                }
                if (obj instanceof TemplateMetaModel || obj instanceof TemplateRefMetaModel) break;
                throw new UnsupportedOperationException("Not yet supported update: " + obj);
            }
        }
    }

    private void processTemplates() {
        for (Map.Entry<ElementHandle.Package, TemplateResolver> entry : this.templateRepositoryMap.entrySet()) {
            TemplateResolver repo = entry.getValue();
            repo.process(this);
        }
    }

    @Override
    public void prePassivate() throws CompilationException {
        log.log("Passivating meta model");
        this.metaModel.prePassivate();
        log.log("Emitting config");
        this.emitConfig();
        log.log("Passivating templates");
        for (TemplateResolver repo : this.templateRepositoryMap.values()) {
            repo.prePassivate();
        }
        this.providers = null;
        this.env = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitConfig() {
        Properties config = new Properties();
        config.putAll(this.moduleConfig);
        Writer writer = null;
        try {
            try {
                FileObject fo = this.env.createResource(StandardLocation.CLASS_OUTPUT, "org.juzu", "config.properties", new Element[0]);
                writer = fo.openWriter();
                config.store(writer, null);
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, (ErrorCode)CompilationErrorCode.CANNOT_WRITE_CONFIG, new Object[0]);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
        Iterator<ApplicationMetaModel> i$ = this.metaModel.getApplications().iterator();
        while (i$.hasNext()) {
            Object var9_12;
            ApplicationMetaModel application = i$.next();
            config.clear();
            for (ControllerMetaModel controller : application.getControllers()) {
                config.put(controller.getHandle().getFQN().getFullName() + "_", "controller");
            }
            TemplateResolver repo = this.templateRepositoryMap.get(application.getHandle());
            if (repo != null) {
                for (Template template : repo.getTemplates()) {
                    config.put(template.getFQN().getFullName(), "template");
                }
            }
            writer = null;
            try {
                try {
                    FileObject fo = this.env.createResource(StandardLocation.CLASS_OUTPUT, application.getFQN().getPackageName(), "config.properties", new Element[0]);
                    writer = fo.openWriter();
                    config.store(writer, null);
                }
                catch (IOException e) {
                    throw new CompilationException((Throwable)e, this.env.get(application.getHandle()), CompilationErrorCode.CANNOT_WRITE_APPLICATION_CONFIG, application.getFQN());
                }
                var9_12 = null;
            }
            catch (Throwable throwable) {
                var9_12 = null;
                Tools.safeClose(writer);
                throw throwable;
            }
            Tools.safeClose(writer);
        }
        return;
    }

    private void emitApplication(ApplicationMetaModel application) throws CompilationException {
        PackageElement elt = this.env.get(application.getHandle());
        FQN fqn = application.getFQN();
        Writer writer = null;
        try {
            try {
                JavaFileObject applicationFile = this.env.createSourceFile(fqn.getFullName(), elt);
                writer = applicationFile.openWriter();
                writer.append("package ").append(fqn.getPackageName()).append(";\n");
                writer.append("import ").append(Tools.getImport(ApplicationDescriptor.class)).append(";\n");
                writer.append("public class ").append(fqn.getSimpleName()).append(" extends ").append(APPLICATION_DESCRIPTOR).append(" {\n");
                writer.append("public static final ").append(fqn.getSimpleName()).append(" DESCRIPTOR = new ").append(fqn.getSimpleName()).append("();\n");
                writer.append("private ").append(fqn.getSimpleName()).append("() {\n");
                writer.append("super(");
                writer.append(application.getDefaultController() != null ? application.getDefaultController() + ".class" : "null");
                writer.append(",");
                writer.append("\"").append(application.getTemplatesQN()).append("\"");
                writer.append(");\n");
                writer.append("}\n");
                writer.append("}\n");
                log.log("Generated application " + fqn.getFullName() + " as " + applicationFile.toUri());
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, elt, CompilationErrorCode.CANNOT_WRITE_APPLICATION, application.getFQN());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }

    private void emitController(ControllerMetaModel controller) throws CompilationException {
        FQN fqn = controller.getHandle().getFQN();
        TypeElement origin = this.env.get(controller.getHandle());
        Writer writer = null;
        try {
            try {
                JavaFileObject file = this.env.createSourceFile(fqn.getFullName() + "_", origin);
                writer = file.openWriter();
                writer.append("package ").append(fqn.getPackageName()).append(";\n");
                writer.append("import ").append(Tools.getImport(ControllerMethod.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(ControllerParameter.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Tools.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Arrays.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Phase.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(URLBuilder.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(InternalApplicationContext.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(MimeContext.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(ActionContext.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Response.Render.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(ControllerDescriptor.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
                writer.append("@Generated(value={})\n");
                writer.append("public class ").append(fqn.getSimpleName()).append("_ extends ").append(CONTROLLER_DESCRIPTOR).append(" {\n");
                writer.append("private ").append(fqn.getSimpleName()).append("_() {\n");
                writer.append("super(").append(fqn.getSimpleName()).append(".class, Arrays.<").append(CONTROLLER_METHOD).append(">asList(");
                List<MethodMetaModel> methods = controller.getMethods();
                for (int j = 0; j < methods.size(); ++j) {
                    MethodMetaModel method = methods.get(j);
                    if (j > 0) {
                        writer.append(',');
                    }
                    writer.append(method.getId());
                }
                writer.append("));\n");
                writer.append("}\n");
                for (MethodMetaModel method : methods) {
                    int j;
                    writer.append("private static final ").append(CONTROLLER_METHOD).append(" ").append(method.getId()).append(" = ");
                    writer.append("new ").append(CONTROLLER_METHOD).append("(");
                    writer.append("\"").append(method.getId()).append("\",");
                    writer.append(PHASE).append(".").append(method.getPhase().name()).append(",");
                    writer.append(fqn.getFullName()).append(".class").append(",");
                    writer.append(TOOLS).append(".safeGetMethod(").append(fqn.getFullName()).append(".class,\"").append(method.getName()).append("\"");
                    for (String parameterType : method.getParameterTypes()) {
                        writer.append(",").append(parameterType).append(".class");
                    }
                    writer.append(")");
                    writer.append(", Arrays.<").append(CONTROLLER_PARAMETER).append(">asList(");
                    Iterator<String> j2 = method.getParameterNames().iterator();
                    while (j2.hasNext()) {
                        String parameterName = j2.next();
                        writer.append("new ").append(CONTROLLER_PARAMETER).append("(\"").append(parameterName).append("\")");
                        if (!j2.hasNext()) continue;
                        writer.append(",");
                    }
                    writer.append(")");
                    writer.append(");\n");
                    if (method.getPhase() == Phase.RENDER) {
                        int j3;
                        writer.append("public static ").append(RESPONSE).append(" ").append(method.getName()).append("(");
                        for (j3 = 0; j3 < method.getParameterTypes().size(); ++j3) {
                            if (j3 > 0) {
                                writer.append(',');
                            }
                            writer.append(method.getParameterTypes().get(j3)).append(" ").append(method.getParameterNames().get(j3));
                        }
                        writer.append(") { return ((ActionContext)InternalApplicationContext.getCurrentRequest()).createResponse(").append(method.getId());
                        switch (method.getParameterTypes().size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                writer.append(",(Object)").append(method.getParameterNames().get(0));
                                break;
                            }
                            default: {
                                writer.append(",new Object[]{");
                                for (j3 = 0; j3 < method.getParameterNames().size(); ++j3) {
                                    if (j3 > 0) {
                                        writer.append(",");
                                    }
                                    writer.append(method.getParameterNames().get(j3));
                                }
                                writer.append("}");
                            }
                        }
                        writer.append("); }\n");
                    }
                    writer.append("public static URLBuilder ").append(method.getName()).append("URL").append("(");
                    for (j = 0; j < method.getParameterTypes().size(); ++j) {
                        if (j > 0) {
                            writer.append(',');
                        }
                        writer.append(method.getParameterTypes().get(j)).append(" ").append(method.getParameterNames().get(j));
                    }
                    writer.append(") { return ((MimeContext)InternalApplicationContext.getCurrentRequest()).createURLBuilder(").append(method.getId());
                    switch (method.getParameterNames().size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            writer.append(",(Object)").append(method.getParameterNames().get(0));
                            break;
                        }
                        default: {
                            writer.append(",new Object[]{");
                            for (j = 0; j < method.getParameterNames().size(); ++j) {
                                if (j > 0) {
                                    writer.append(",");
                                }
                                writer.append(method.getParameterNames().get(j));
                            }
                            writer.append("}");
                        }
                    }
                    writer.append("); }\n");
                }
                writer.append("public static final ").append(fqn.getSimpleName()).append("_ INSTANCE = new ").append(fqn.getSimpleName()).append("_();\n");
                writer.append("}\n");
                log.log("Generated controller companion " + fqn.getFullName() + "_" + " as " + file.toUri());
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, origin, CompilationErrorCode.CANNOT_WRITE_CONTROLLER_COMPANION, controller.getHandle().getFQN());
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }
}

