/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFileSystem<P> {
    public final <A extends Appendable> A packageOf(P path, char separator, A appendable) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        ArrayList<String> l = new ArrayList<String>();
        this.packageOf(path, l);
        this.bilto(l, separator, appendable);
        return appendable;
    }

    public final void pathOf(P path, Collection<String> to) throws IOException {
        this.packageOf(path, to);
        if (this.isFile(path)) {
            String name = this.getName(path);
            to.add(name);
        }
    }

    public final void pathOf(P path, char separator, Appendable appendable) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (appendable == null) {
            throw new NullPointerException("No null appendable accepted");
        }
        ArrayList<String> l = new ArrayList<String>();
        this.pathOf(path, l);
        this.bilto(l, separator, appendable);
    }

    private void bilto(Collection<String> l, char separator, Appendable appendable) throws IOException {
        boolean dot = false;
        for (String name : l) {
            if (dot) {
                appendable.append(separator);
            } else {
                dot = true;
            }
            appendable.append(name);
        }
    }

    public final P getPath(String ... names) throws IOException {
        return this.getPath(Arrays.asList(names));
    }

    public abstract String getName(P var1) throws IOException;

    public abstract P getPath(Iterable<String> var1) throws IOException;

    public abstract void packageOf(P var1, Collection<String> var2) throws IOException;

    public abstract Iterator<P> getChildren(P var1) throws IOException;

    public abstract boolean isDir(P var1) throws IOException;

    public abstract boolean isFile(P var1) throws IOException;

    public abstract Content getContent(P var1) throws IOException;

    public abstract File getFile(P var1) throws IOException;
}

