/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.juzu.impl.spi.fs.SimpleFileSystem;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFileSystem
extends SimpleFileSystem<String> {
    private final ClassLoader classLoader;
    private Map<URL, String[]> cache;

    public ClassLoaderFileSystem(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("No null class loader accepted");
        }
        this.classLoader = classLoader;
        this.cache = new HashMap<URL, String[]>();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getName(String path) throws IOException {
        if ("".equals(path) || "/".equals(path)) {
            return "";
        }
        if (this.isDir(path)) {
            int index = path.lastIndexOf(47, path.length() - 2);
            if (index == -1) {
                index = 0;
            }
            return path.substring(index, path.length() - 1);
        }
        int index = path.lastIndexOf(47);
        return index == -1 ? path : path.substring(index + 1);
    }

    @Override
    public String getPath(Iterable<String> names) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean foo = true;
        for (String name : names) {
            if (foo) {
                foo = false;
            } else {
                sb.append('/');
            }
            sb.append(name);
        }
        sb.append('/');
        String path = sb.toString();
        URL url = this.classLoader.getResource(path);
        if (url == null) {
            path = sb.substring(0, sb.length() - 1);
            url = this.classLoader.getResource(path);
        }
        return url != null ? path : null;
    }

    @Override
    public void packageOf(String path, Collection<String> to) throws IOException {
        int prev = 0;
        int next = path.indexOf(47);
        while (next != -1) {
            to.add(path.substring(prev, next));
            prev = next + 1;
            next = path.indexOf(47, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getChildren(String dir) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        Enumeration<URL> e = this.classLoader.getResources(dir);
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            String protocol = url.getProtocol();
            if (protocol.equals("jar")) {
                int pos;
                String path = url.getPath();
                URL url2 = new URL(path.substring(0, pos = path.indexOf("!/")));
                String[] entries = this.cache.get(url2);
                if (entries == null) {
                    Object var14_17;
                    JarInputStream in = new JarInputStream(url2.openStream());
                    try {
                        ArrayList<String> tmp = new ArrayList<String>();
                        JarEntry jarEntry = in.getNextJarEntry();
                        while (jarEntry != null) {
                            tmp.add(jarEntry.getName());
                            jarEntry = in.getNextJarEntry();
                        }
                        entries = tmp.toArray(new String[tmp.size()]);
                        this.cache.put(url2, entries);
                        var14_17 = null;
                    }
                    catch (Throwable throwable) {
                        var14_17 = null;
                        Tools.safeClose(in);
                        throw throwable;
                    }
                    Tools.safeClose(in);
                    {
                    }
                }
                for (String entry : entries) {
                    if (entry.length() <= dir.length() + 1 || !entry.startsWith(dir) || entry.indexOf(47, dir.length() + 1) != -1) continue;
                    ret.add(entry);
                }
                continue;
            }
            throw new UnsupportedOperationException("todo");
        }
        return ret.iterator();
    }

    @Override
    public boolean isDir(String path) throws IOException {
        return path.length() == 0 || path.endsWith("/");
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return !this.isDir(path);
    }

    @Override
    public Content getContent(String file) throws IOException {
        URL url = this.classLoader.getResource(file);
        if (url == null) {
            throw new UnsupportedOperationException("handle me correctly");
        }
        URLConnection conn = url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Content(lastModified, bytes, Charset.defaultCharset());
    }

    @Override
    public File getFile(String path) throws IOException {
        throw new UnsupportedOperationException();
    }
}

