/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.spring;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.juzu.impl.inject.ScopeController;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.spring.ProviderBean;
import org.juzu.impl.spi.inject.spring.ScopeMetadataResolverImpl;
import org.juzu.impl.spi.inject.spring.SpringManager;
import org.juzu.impl.spi.inject.spring.SpringScope;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.CustomAutowireConfigurer;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBootstrap
extends InjectBootstrap {
    private ClassLoader classLoader;
    private Map<String, Class<?>> beans = new LinkedHashMap();
    private Map<String, Object> singletons = new LinkedHashMap<String, Object>();
    private Set<Scope> scopes = new LinkedHashSet<Scope>();
    private URL configurationURL;

    @Override
    public <T> InjectBootstrap declareBean(Class<T> type, Class<? extends T> implementationType) {
        if (implementationType == null) {
            implementationType = type;
        }
        String name = "" + Math.random();
        for (Annotation annotation : implementationType.getDeclaredAnnotations()) {
            if (!(annotation instanceof Named)) continue;
            Named named = (Named)annotation;
            name = named.value();
            break;
        }
        this.beans.put(name, implementationType);
        return this;
    }

    public URL getConfigurationURL() {
        return this.configurationURL;
    }

    public void setConfigurationURL(URL configurationURL) {
        this.configurationURL = configurationURL;
    }

    @Override
    public <T> InjectBootstrap declareProvider(Class<T> type, Class<? extends Provider<T>> provider) {
        return this;
    }

    @Override
    public <T> InjectBootstrap bindBean(Class<T> type, T instance) {
        String name = "" + Math.random();
        this.singletons.put(name, instance);
        return this;
    }

    @Override
    public <T> InjectBootstrap bindProvider(Class<T> type, Provider<T> provider) {
        return this.bindBean(ProviderBean.class, new ProviderBean<T>(type, provider));
    }

    @Override
    public <P> InjectBootstrap addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public InjectBootstrap addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public InjectBootstrap setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <B, I> InjectManager<B, I> create() throws Exception {
        Object factory = this.configurationURL != null ? new XmlBeanFactory((Resource)new UrlResource(this.configurationURL)) : new DefaultListableBeanFactory();
        factory.setBeanClassLoader(this.classLoader);
        for (Scope scope : this.scopes) {
            factory.registerScope(scope.name().toLowerCase(), (org.springframework.beans.factory.config.Scope)new SpringScope(scope, ScopeController.INSTANCE));
        }
        for (Map.Entry entry : this.singletons.entrySet()) {
            factory.registerSingleton((String)entry.getKey(), entry.getValue());
        }
        ScopeMetadataResolverImpl resolver = new ScopeMetadataResolverImpl(this.scopes);
        for (Map.Entry<String, Class<?>> entry : this.beans.entrySet()) {
            AnnotatedGenericBeanDefinition definition = new AnnotatedGenericBeanDefinition(entry.getValue());
            ScopeMetadata scopeMD = resolver.resolveScopeMetadata((BeanDefinition)definition);
            if (scopeMD != null) {
                definition.setScope(scopeMD.getScopeName());
            }
            factory.registerBeanDefinition(entry.getKey(), (BeanDefinition)definition);
        }
        AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        autowiredAnnotationBeanPostProcessor.setAutowiredAnnotationType(Inject.class);
        autowiredAnnotationBeanPostProcessor.setBeanFactory((BeanFactory)factory);
        factory.addBeanPostProcessor((BeanPostProcessor)autowiredAnnotationBeanPostProcessor);
        HashSet<Class<Named>> cqt = new HashSet<Class<Named>>();
        cqt.add(Named.class);
        CustomAutowireConfigurer configurer = new CustomAutowireConfigurer();
        configurer.setCustomQualifierTypes(cqt);
        QualifierAnnotationAutowireCandidateResolver customResolver = new QualifierAnnotationAutowireCandidateResolver();
        factory.setAutowireCandidateResolver((AutowireCandidateResolver)customResolver);
        configurer.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
        return new SpringManager((DefaultListableBeanFactory)factory, this.classLoader);
    }
}

