/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.template;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.juzu.impl.spi.template.TemplateGenerator;
import org.juzu.impl.template.ExtendedTagHandler;
import org.juzu.impl.template.OffsetCharStream;
import org.juzu.impl.template.OffsetReader;
import org.juzu.impl.template.OffsetTokenManager;
import org.juzu.impl.template.ParseException;
import org.juzu.impl.template.SectionType;
import org.juzu.impl.template.TemplateCompilationContext;
import org.juzu.impl.template.TemplateParser;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.impl.utils.Tools;
import org.juzu.template.TagHandler;
import org.juzu.text.Coordinate;
import org.juzu.text.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTNode<N extends ASTNode<N>>
implements Serializable {
    private static final Coordinate DUMB = new Coordinate(0, new Location(1, 1));
    private final Location beginPosition;
    protected final List<Block<?>> children;
    private final List<Block<?>> unmodifiableChildren;

    protected ASTNode(Location beginPosition, List<Block<?>> children) {
        if (beginPosition == null) {
            throw new NullPointerException("No null position accepted");
        }
        this.beginPosition = beginPosition;
        this.children = children;
        this.unmodifiableChildren = children != null ? Collections.unmodifiableList(children) : Collections.emptyList();
    }

    public Location getBeginPosition() {
        return this.beginPosition;
    }

    public List<Block<?>> getChildren() {
        return this.unmodifiableChildren;
    }

    public N addChildren(Iterable<Block<?>> children) {
        for (Block<?> child : children) {
            this.addChild(child);
        }
        return (N)this;
    }

    public N addChild(Block<?> child) {
        if (this.children == null) {
            throw new IllegalStateException("Node " + this + " cannot have children");
        }
        if (((Block)child).parent != null) {
            ((Block)child).parent.children.remove(child);
            ((Block)child).parent = null;
        }
        ((Block)child).parent = this;
        this.children.add(child);
        return (N)this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Section
    extends Block<Section> {
        private final SectionType type;
        private final String text;

        public Section(SectionType type, String text) {
            this(DUMB, DUMB, type, text);
        }

        public Section(Coordinate begin, Coordinate end, SectionType type, String text) {
            super(begin, end, null);
            if (type == null) {
                throw new NullPointerException();
            }
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
            this.type = type;
        }

        public SectionType getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Section) {
                Section that = (Section)obj;
                return this.type == that.type && this.text.equals(that.text);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.type) + ",text=" + this.text + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URL
    extends Block<URL> {
        private final String typeName;
        private final String methodName;
        private final Map<String, String> args;

        public URL(String typeName, String methodName, Map<String, String> args) {
            this(DUMB, DUMB, typeName, methodName, args);
        }

        public URL(Coordinate begin, Coordinate end, String typeName, String methodName, Map<String, String> args) {
            super(begin, end, null);
            this.typeName = typeName;
            this.methodName = methodName;
            this.args = args;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof URL) {
                URL that = (URL)obj;
                return Tools.safeEquals(this.typeName, that.typeName) && this.methodName.equals(that.methodName) && ((Object)this.args).equals(that.args);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.methodName + ",args=" + this.args + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tag
    extends Block<Tag> {
        private final String name;
        private final Map<String, String> args;
        private transient TagHandler handler;

        public Tag(String name) {
            this(name, Collections.emptyMap());
        }

        public Tag(String name, Map<String, String> args) {
            this(DUMB, DUMB, name, args);
        }

        public Tag(Coordinate begin, Coordinate end, String name, Map<String, String> args) {
            super(begin, end, new ArrayList());
            this.name = name;
            this.args = args;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tag) {
                Tag that = (Tag)obj;
                return this.name.equals(this.name) && ((Object)this.args).equals(that.args) && ((Object)this.children).equals(that.children);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.name + ",args=" + this.args + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Block<B extends Block<B>>
    extends ASTNode<B> {
        private final Coordinate begin;
        private final Coordinate end;
        private ASTNode<?> parent;

        protected Block(Coordinate begin, Coordinate end, List<Block<?>> children) {
            super(begin.getPosition(), children);
            this.begin = begin;
            this.end = end;
            this.parent = null;
        }

        public ASTNode<?> getParent() {
            return this.parent;
        }

        public void addAfter(Block sibling) {
            if (sibling.parent != null) {
                sibling.parent.children.remove(sibling);
                sibling.parent = null;
            }
            int index = this.parent.children.indexOf(this);
            this.parent.children.add(index + 1, sibling);
            sibling.parent = this.parent;
        }

        public void remove() throws IllegalStateException {
            if (this.parent == null) {
                throw new IllegalStateException("No parent");
            }
            this.parent.children.remove(this);
            this.parent = null;
        }

        public Coordinate getBegin() {
            return this.begin;
        }

        public Coordinate getEnd() {
            return this.end;
        }

        public int getBeginOffset() {
            return this.begin.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public Location getEndPosition() {
            return this.end.getPosition();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Template
    extends ASTNode<Template> {
        public static Template parse(CharSequence s) throws ParseException {
            TemplateParser parser = new TemplateParser(new OffsetTokenManager(new OffsetCharStream(new OffsetReader(new StringReader(((Object)s).toString())))));
            return parser.parse();
        }

        Template() {
            super(new Location(0, 0), new ArrayList());
        }

        public void generate(TemplateGenerator generator, TemplateCompilationContext tcc) throws IOException {
            this.process(tcc);
            this.emit(tcc, generator);
        }

        public void process(TemplateCompilationContext tcc) {
            this.attribute(tcc, this);
            this.process(tcc, this);
            this.resolve(tcc, this);
            this.unattribute(tcc, this);
        }

        public void emit(TemplateCompilationContext tcc, TemplateGenerator generator) throws IOException {
            this.attribute(tcc, this);
            this.emit(tcc, new GeneratorContext(generator), this.getChildren());
            this.unattribute(tcc, this);
        }

        private void attribute(TemplateCompilationContext tcc, ASTNode<?> node) {
            block4: {
                block3: {
                    if (!(node instanceof Template)) break block3;
                    for (Block<?> child : node.getChildren()) {
                        this.attribute(tcc, child);
                    }
                    break block4;
                }
                if (node instanceof Section || node instanceof URL || !(node instanceof Tag)) break block4;
                Tag nodeTag = (Tag)node;
                TagHandler handler = tcc.resolve(nodeTag.name);
                if (handler == null) {
                    throw new UnsupportedOperationException("handle me gracefully " + nodeTag.name);
                }
                nodeTag.handler = handler;
                for (Block child : nodeTag.children) {
                    this.attribute(tcc, child);
                }
            }
        }

        private void process(TemplateCompilationContext tcc, ASTNode<?> node) {
            block4: {
                block3: {
                    if (!(node instanceof Template)) break block3;
                    for (Block<?> child : node.getChildren()) {
                        this.process(tcc, child);
                    }
                    break block4;
                }
                if (node instanceof Section || node instanceof URL || !(node instanceof Tag)) break block4;
                Tag nodeTag = (Tag)node;
                if (nodeTag.handler instanceof ExtendedTagHandler) {
                    ((ExtendedTagHandler)nodeTag.handler).process(nodeTag);
                }
                for (Block child : nodeTag.children) {
                    this.process(tcc, child);
                }
            }
        }

        private void resolve(TemplateCompilationContext tcc, ASTNode<?> node) {
            block4: {
                block3: {
                    if (!(node instanceof Template)) break block3;
                    for (Block<?> child : node.getChildren()) {
                        this.resolve(tcc, child);
                    }
                    break block4;
                }
                if (node instanceof Section || node instanceof URL || !(node instanceof Tag)) break block4;
                Tag nodeTag = (Tag)node;
                if (nodeTag.handler instanceof ExtendedTagHandler) {
                    ((ExtendedTagHandler)nodeTag.handler).compile(tcc, nodeTag.args);
                }
                for (Block child : nodeTag.children) {
                    this.resolve(tcc, child);
                }
            }
        }

        private void unattribute(TemplateCompilationContext tcc, ASTNode<?> node) {
            block3: {
                block2: {
                    if (!(node instanceof Template)) break block2;
                    for (Block<?> child : node.getChildren()) {
                        this.unattribute(tcc, child);
                    }
                    break block3;
                }
                if (node instanceof Section || node instanceof URL || !(node instanceof Tag)) break block3;
                Tag nodeTag = (Tag)node;
                nodeTag.handler = null;
                for (Block child : nodeTag.children) {
                    this.attribute(tcc, child);
                }
            }
        }

        private void emit(TemplateCompilationContext tcc, GeneratorContext ctx, List<Block<?>> blocks) throws IOException {
            for (Block<?> block : blocks) {
                if (block instanceof Section) {
                    String chunk;
                    int to;
                    Section section = (Section)block;
                    ctx.begin(section.getType(), section.getBeginPosition());
                    int lineNumber = section.getBegin().getPosition().getLine();
                    int colNumber = section.getBegin().getPosition().getCol();
                    String text = section.text;
                    int from = 0;
                    while ((to = text.indexOf(10, from)) != -1) {
                        chunk = text.substring(from, to);
                        ctx.appendText(chunk);
                        ctx.appendLineBreak(new Location(colNumber + (to - from), lineNumber));
                        from = to + 1;
                        ++lineNumber;
                        colNumber = 1;
                    }
                    chunk = text.substring(from);
                    ctx.appendText(chunk);
                    ctx.end();
                    continue;
                }
                if (block instanceof URL) {
                    URL url = (URL)block;
                    MethodInvocation mi = tcc.resolveMethodInvocation(url.typeName, url.methodName, url.args);
                    if (mi == null) {
                        throw new UnsupportedOperationException("handle me gracefully");
                    }
                    ctx.writer.url(mi.getClassName(), mi.getMethodName(), mi.getMethodArguments());
                    continue;
                }
                if (block instanceof Tag) {
                    Tag tag = (Tag)block;
                    String className = tag.handler.getClass().getName();
                    if (tag.children != null) {
                        ctx.writer.openTag(className, tag.args);
                        this.emit(tcc, ctx, tag.children);
                        ctx.writer.closeTag(className, tag.args);
                        continue;
                    }
                    ctx.writer.tag(className, tag.args);
                    continue;
                }
                throw new AssertionError();
            }
        }

        private class GeneratorContext {
            private SectionType currentType = null;
            private StringBuilder accumulatedText = new StringBuilder();
            private TemplateGenerator writer;

            GeneratorContext(TemplateGenerator writer) {
                this.writer = writer;
            }

            void begin(SectionType sectionType, Location pos) {
                if (sectionType == null) {
                    throw new NullPointerException();
                }
                if (pos == null) {
                    throw new NullPointerException();
                }
                if (this.currentType != null) {
                    throw new IllegalStateException();
                }
                this.currentType = sectionType;
                switch (this.currentType) {
                    case STRING: {
                        break;
                    }
                    case SCRIPTLET: {
                        this.writer.startScriptlet(pos);
                        break;
                    }
                    case EXPR: {
                        this.writer.startExpression(pos);
                    }
                }
            }

            void appendText(String text) {
                switch (this.currentType) {
                    case STRING: {
                        this.accumulatedText.append(text);
                        break;
                    }
                    case SCRIPTLET: {
                        this.writer.appendScriptlet(text);
                        break;
                    }
                    case EXPR: {
                        this.writer.appendExpression(text);
                    }
                }
            }

            void appendLineBreak(Location position) {
                switch (this.currentType) {
                    case STRING: {
                        this.accumulatedText.append("\n");
                        break;
                    }
                    case SCRIPTLET: {
                        this.writer.appendLineBreak(this.currentType, position);
                        break;
                    }
                    case EXPR: {
                        this.writer.appendLineBreak(this.currentType, position);
                    }
                }
            }

            void end() {
                if (this.currentType == null) {
                    throw new IllegalStateException();
                }
                switch (this.currentType) {
                    case STRING: {
                        if (this.accumulatedText.length() <= 0) break;
                        this.writer.appendText(this.accumulatedText.toString());
                        this.accumulatedText.setLength(0);
                        break;
                    }
                    case SCRIPTLET: {
                        this.writer.endScriptlet();
                        break;
                    }
                    case EXPR: {
                        this.writer.endExpression();
                    }
                }
                this.currentType = null;
            }
        }
    }
}

