/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class Content {
    private long lastModified;
    private byte[] data;
    private Charset encoding;

    public Content(long lastModified, byte[] data, Charset encoding) {
        if (data == null) {
            throw new NullPointerException("No null data accepted");
        }
        this.lastModified = lastModified;
        this.data = data;
        this.encoding = encoding;
    }

    public Content(long lastModified, CharSequence s) {
        this(lastModified, s, Charset.defaultCharset());
    }

    public Content(long lastModified, CharSequence s, Charset encoding) {
        this.encoding = encoding;
        this.lastModified = lastModified;
        this.data = ((Object)s).toString().getBytes(encoding);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public CharSequence getCharSequence(Charset encoding) {
        return new String(this.data, encoding);
    }

    public CharSequence getCharSequence() {
        if (this.encoding == null) {
            throw new IllegalStateException("No encoding set");
        }
        return new String(this.data, this.encoding);
    }

    public Content touch() {
        this.lastModified = System.currentTimeMillis();
        return this;
    }

    public int getSize() {
        return this.data.length;
    }
}

