/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.Serializable;
import org.juzu.impl.utils.QN;

public class FQN
implements Serializable {
    private final String fullName;
    private final QN packageName;
    private final String simpleName;

    public FQN(String fullName) {
        String simpleName;
        QN packageName;
        int pos = fullName.lastIndexOf(46);
        if (pos == -1) {
            packageName = new QN("");
            simpleName = fullName;
        } else {
            packageName = new QN(fullName.substring(0, pos));
            simpleName = fullName.substring(pos + 1);
        }
        this.fullName = fullName;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public FQN(CharSequence packageName, String simpleName) {
        this(new QN(packageName), simpleName);
    }

    public FQN(QN packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.fullName = packageName.isEmpty() ? simpleName : packageName + "." + simpleName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public QN getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FQN) {
            FQN that = (FQN)obj;
            return this.packageName.equals(that.packageName) && this.simpleName.equals(that.simpleName);
        }
        return false;
    }

    public String toString() {
        return this.fullName;
    }
}

