/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.application;

import java.util.ArrayList;
import java.util.List;
import org.juzu.AmbiguousResolutionException;
import org.juzu.metadata.ApplicationDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.request.Phase;

public class ControllerResolver {
    private final List<ControllerMethod> methods;
    private final ApplicationDescriptor desc;

    public ControllerResolver(ApplicationDescriptor desc) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException("No null application descriptor accepted");
        }
        this.desc = desc;
        this.methods = desc.getControllerMethods();
    }

    public ControllerMethod resolve(Phase phase, String methodId) throws AmbiguousResolutionException {
        ControllerMethod found = null;
        if (methodId != null) {
            for (ControllerMethod method : this.methods) {
                if (!method.getId().equals(methodId)) continue;
                found = method;
                break;
            }
        } else if (phase == Phase.RENDER) {
            ArrayList<Foo> matches = new ArrayList<Foo>();
            for (ControllerMethod method : this.methods) {
                if (method.getPhase() != Phase.RENDER || !method.getName().equals("index")) continue;
                matches.add(new Foo(method));
            }
            int size = matches.size();
            if (size > 0) {
                if (size > 1) {
                    Foo first = (Foo)matches.get(0);
                    Foo second = (Foo)matches.get(1);
                    if (first.score == second.score) {
                        throw new AmbiguousResolutionException("Two methods satisfies the index criteria: " + first.m + " and " + second.m);
                    }
                }
                found = ((Foo)matches.get((int)0)).m;
            }
        }
        return found;
    }

    private int getScore(ControllerMethod m) {
        return m.getArgumentParameters().size() + (m.getType() == this.desc.getDefaultController() ? 0 : 1000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Foo
    implements Comparable<Foo> {
        int score;
        ControllerMethod m;

        private Foo(ControllerMethod m) {
            this.score = m.getArgumentParameters().size() + (m.getType() == ControllerResolver.this.desc.getDefaultController() ? 0 : 1000);
            this.m = m;
        }

        @Override
        public int compareTo(Foo o) {
            return this.score - o.score;
        }
    }
}

