/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.QN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementHandle<E extends Element>
implements Serializable {
    public static ElementHandle<?> create(Element elt) {
        ElementKind kind = elt.getKind();
        switch (kind) {
            case FIELD: {
                VariableElement variableElt = (VariableElement)elt;
                return Field.create(variableElt);
            }
            case CLASS: {
                TypeElement typeElt = (TypeElement)elt;
                return Class.create(typeElt);
            }
            case PACKAGE: {
                PackageElement packageElt = (PackageElement)elt;
                return Package.create(packageElt);
            }
            case METHOD: {
                ExecutableElement packageElt = (ExecutableElement)elt;
                return Method.create(packageElt);
            }
        }
        throw new UnsupportedOperationException("Element " + elt + " with kind " + (Object)((Object)kind) + " not supported");
    }

    public final E get(ProcessingEnvironment env) {
        try {
            return this.doGet(env);
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().equals("org.eclipse.jdt.internal.compiler.problem.AbortCompilation")) {
                return null;
            }
            throw e;
        }
    }

    protected abstract E doGet(ProcessingEnvironment var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field
    extends ElementHandle<VariableElement> {
        private final FQN fqn;
        private final String name;

        public static Field create(VariableElement elt) {
            TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
            String name = elt.getSimpleName().toString();
            FQN fqn = new FQN(typeElt.getQualifiedName().toString());
            return new Field(fqn, name);
        }

        public static Field create(FQN fqn, String name) {
            return new Field(fqn, name);
        }

        private Field(FQN fqn, String name) {
            this.fqn = fqn;
            this.name = name;
        }

        public FQN getFQN() {
            return this.fqn;
        }

        public String getName() {
            return this.name;
        }

        @Override
        protected VariableElement doGet(ProcessingEnvironment env) {
            TypeElement typeElt = env.getElementUtils().getTypeElement(this.fqn.getFullName());
            if (typeElt != null) {
                for (VariableElement variableElt : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                    if (!variableElt.getSimpleName().contentEquals(this.name)) continue;
                    return variableElt;
                }
            }
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Field) {
                Field that = (Field)obj;
                return this.fqn.equals(that.fqn) && this.name.equals(that.name);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.fqn.hashCode() ^ this.name.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Field[fqn=" + this.fqn + ",name=" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Method
    extends ElementHandle<ExecutableElement> {
        private final FQN fqn;
        private final String name;
        private final ArrayList<String> parameterTypes;

        public static Method create(FQN fqn, String name, Collection<String> parameterTypes) {
            return new Method(fqn, name, new ArrayList<String>(parameterTypes));
        }

        public static Method create(ExecutableElement elt) {
            TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
            String name = elt.getSimpleName().toString();
            FQN fqn = new FQN(typeElt.getQualifiedName().toString());
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (TypeMirror typeMirror : ((ExecutableType)elt.asType()).getParameterTypes()) {
                parameterTypes.add(((Object)typeMirror).toString());
            }
            return new Method(fqn, name, parameterTypes);
        }

        private Method(FQN fqn, String name, ArrayList<String> parameterTypes) {
            this.fqn = fqn;
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public FQN getFQN() {
            return this.fqn;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        protected ExecutableElement doGet(ProcessingEnvironment env) {
            TypeElement typeElt = env.getElementUtils().getTypeElement(this.fqn.getFullName());
            if (typeElt != null) {
                block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                    List<? extends TypeMirror> parameterTypes;
                    int len;
                    if (!executableElement.getSimpleName().toString().equals(this.name) || (len = (parameterTypes = ((ExecutableType)executableElement.asType()).getParameterTypes()).size()) != this.parameterTypes.size()) continue;
                    for (int i = 0; i < len; ++i) {
                        if (!((Object)parameterTypes.get(i)).toString().equals(this.parameterTypes.get(i))) continue block0;
                    }
                    return executableElement;
                }
            }
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Method) {
                Method that = (Method)obj;
                return this.fqn.equals(that.fqn) && this.name.equals(that.name) && this.parameterTypes.equals(that.parameterTypes);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = this.fqn.hashCode() ^ this.name.hashCode();
            for (String parameterType : this.parameterTypes) {
                hashCode = hashCode * 41 + parameterType.hashCode();
            }
            return hashCode;
        }

        @Override
        public String toString() {
            return "ElementHandle.Method[fqn=" + this.fqn + ",name=" + this.name + ",parameterTypes" + this.parameterTypes + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Class
    extends ElementHandle<TypeElement> {
        private final FQN fqn;

        public static Class create(FQN fqn) {
            return new Class(fqn);
        }

        public static Class create(TypeElement elt) {
            return new Class(new FQN(elt.getQualifiedName().toString()));
        }

        private Class(FQN fqn) {
            this.fqn = fqn;
        }

        public FQN getFQN() {
            return this.fqn;
        }

        @Override
        protected TypeElement doGet(ProcessingEnvironment env) {
            return env.getElementUtils().getTypeElement(this.fqn.getFullName());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Class) {
                Class that = (Class)obj;
                return this.fqn.equals(that.fqn);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.fqn.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Class[fqn=" + this.fqn + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Package
    extends ElementHandle<PackageElement> {
        private final QN qn;

        public static Package create(QN packageName) {
            return new Package(packageName);
        }

        public static Package create(PackageElement elt) {
            return new Package(new QN(elt.getQualifiedName().toString()));
        }

        private Package(QN qn) {
            this.qn = qn;
        }

        public QN getQN() {
            return this.qn;
        }

        @Override
        protected PackageElement doGet(ProcessingEnvironment env) {
            return env.getElementUtils().getPackageElement(this.qn);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Package) {
                Package that = (Package)obj;
                return this.qn.equals(that.qn);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.qn.hashCode();
        }

        @Override
        public String toString() {
            return "ElementHandle.Package[qn=" + this.qn + "]";
        }
    }
}

