/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.compiler.file;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.juzu.impl.compiler.file.FileKey;
import org.juzu.impl.compiler.file.FileManager;
import org.juzu.impl.compiler.file.JavaFileObjectImpl;
import org.juzu.impl.spi.fs.ReadWriteFileSystem;
import org.juzu.impl.spi.fs.SimpleFileSystem;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileManager<P>
extends FileManager {
    final SimpleFileSystem<P> fs;
    final Map<FileKey, JavaFileObjectImpl<P>> entries;

    public static <P> SimpleFileManager<P> wrap(SimpleFileSystem<P> fs) {
        return new SimpleFileManager<P>(fs);
    }

    public SimpleFileManager(SimpleFileSystem<P> fs) {
        this.fs = fs;
        this.entries = new HashMap<FileKey, JavaFileObjectImpl<P>>();
    }

    public SimpleFileSystem<P> getFileSystem() {
        return this.fs;
    }

    @Override
    public void clearCache() {
        this.entries.clear();
    }

    @Override
    public JavaFileObject getReadable(FileKey key) throws IOException {
        P file;
        JavaFileObjectImpl<P> entry = this.entries.get(key);
        if (entry == null && (file = this.fs.getPath(key.names)) != null && this.fs.isFile(file)) {
            entry = new JavaFileObjectImpl<P>(key, this, file);
            this.entries.put(key, entry);
        }
        return entry;
    }

    @Override
    public JavaFileObject getWritable(FileKey key) throws IOException {
        if (this.fs instanceof ReadWriteFileSystem) {
            ReadWriteFileSystem rwFS = (ReadWriteFileSystem)this.fs;
            JavaFileObjectImpl<P> entry = this.entries.get(key);
            if (entry == null) {
                Object file = rwFS.getPath(key.names);
                entry = new JavaFileObjectImpl(key, this, file);
                this.entries.put(key, entry);
            }
            return entry;
        }
        throw new UnsupportedOperationException("File system is not writable");
    }

    @Override
    public <C extends Collection<JavaFileObject>> C list(String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse, C to) throws IOException {
        Iterable<String> packageNames = Spliterator.split(packageName, '.');
        P dir = this.fs.getPath(packageNames);
        if (dir != null && this.fs.isDir(dir)) {
            this.list(dir, kinds, recurse, to);
        }
        return to;
    }

    private void list(P root, Set<JavaFileObject.Kind> kinds, boolean recurse, Collection<JavaFileObject> to) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.fs.packageOf(root, '.', sb);
        String packageName = sb.toString();
        Iterator<P> i = this.fs.getChildren(root);
        while (i.hasNext()) {
            P child = i.next();
            if (this.fs.isDir(child)) {
                if (!recurse) continue;
                this.list(child, kinds, true, to);
                continue;
            }
            String name = this.fs.getName(child);
            FileKey key = FileKey.newName(packageName, name);
            if (!kinds.contains((Object)key.kind)) continue;
            to.add(this.getReadable(key));
        }
    }
}

