/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.juzu.AmbiguousResolutionException;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.meta.ControllerMetaModel;
import org.juzu.impl.model.meta.MetaModel;
import org.juzu.impl.model.meta.MetaModelEvent;
import org.juzu.impl.model.meta.MetaModelObject;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.meta.TemplateRefMetaModel;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.JSON;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.QN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMetaModel
extends MetaModelObject {
    private static final Logger log = BaseProcessor.getLogger(ApplicationMetaModel.class);
    LinkedHashMap<ElementHandle.Class, ControllerMetaModel> controllers = new LinkedHashMap();
    LinkedHashMap<String, TemplateMetaModel> templates = new LinkedHashMap();
    final ElementHandle.Package handle;
    final FQN fqn;
    final String defaultController;
    final Boolean escapeXML;
    final QN templatesQN;
    final MetaModel model;
    boolean modified;

    ApplicationMetaModel(MetaModel model, ElementHandle.Package handle, String applicationName, String defaultController, Boolean escapeXML) {
        this.model = model;
        this.handle = handle;
        this.fqn = new FQN(handle.getQN(), applicationName);
        this.defaultController = defaultController;
        this.escapeXML = escapeXML;
        this.templatesQN = this.fqn.getPackageName().append("templates");
        this.modified = false;
    }

    public String getDefaultController() {
        return this.defaultController;
    }

    public Boolean getEscapeXML() {
        return this.escapeXML;
    }

    public QN getTemplatesQN() {
        return this.templatesQN;
    }

    public FQN getFQN() {
        return this.fqn;
    }

    public ElementHandle.Package getHandle() {
        return this.handle;
    }

    public TemplateMetaModel getTemplate(String path) {
        return this.templates.get(path);
    }

    public Collection<TemplateMetaModel> getTemplates() {
        return new ArrayList<TemplateMetaModel>(this.templates.values());
    }

    public Collection<ControllerMetaModel> getControllers() {
        return new ArrayList<ControllerMetaModel>(this.controllers.values());
    }

    public TemplateMetaModel addTemplate(TemplateRefMetaModel ref) {
        if (this.templates.containsKey(ref.path)) {
            throw new IllegalStateException("Template path already existing");
        }
        TemplateMetaModel template = new TemplateMetaModel(this, ref);
        this.templates.put(template.path, template);
        this.model.queue(new MetaModelEvent(0, template));
        return template;
    }

    public void removeTemplate(TemplateMetaModel template) {
        if (template.application != this) {
            throw new IllegalArgumentException();
        }
        if (!this.templates.containsKey(template.path)) {
            throw new IllegalStateException();
        }
        this.model.queue(new MetaModelEvent(1, template));
        for (TemplateRefMetaModel ref : template.getRefs()) {
            template.removeRef(ref);
        }
        this.templates.remove(template.getPath());
        template.application = null;
    }

    public void addController(ControllerMetaModel controller) {
        if (this.controllers.containsKey(controller.handle)) {
            throw new IllegalStateException();
        }
        this.controllers.put(controller.handle, controller);
        controller.application = this;
        this.model.queue(new MetaModelEvent(0, controller));
    }

    public void removeController(ControllerMetaModel controller) {
        if (controller.application != this) {
            throw new IllegalArgumentException();
        }
        if (!this.controllers.containsKey(controller.handle)) {
            throw new IllegalStateException();
        }
        this.model.queue(new MetaModelEvent(1, controller));
        this.controllers.remove(controller.handle);
        controller.application = null;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.add("handle", this.handle);
        json.add("fqn", this.fqn);
        json.add("defaultController", this.defaultController);
        json.add("templates", this.templates.values());
        json.add("controllers", this.controllers.keySet());
        return json;
    }

    public MethodMetaModel resolve(String typeName, String methodName, Set<String> parameterNames) throws AmbiguousResolutionException {
        TreeSet<MethodMetaModel> set = new TreeSet<MethodMetaModel>(new Comparator<MethodMetaModel>(){

            @Override
            public int compare(MethodMetaModel o1, MethodMetaModel o2) {
                return Integer.valueOf(o1.parameterNames.size()).compareTo(o2.parameterNames.size());
            }
        });
        log.log("About to search method in controllers " + this.controllers.keySet());
        for (ControllerMetaModel controller : this.controllers.values()) {
            for (MethodMetaModel method : controller.methods.values()) {
                boolean add = false;
                if ((typeName == null || controller.getHandle().getFQN().getSimpleName().equals(typeName)) && method.name.equals(methodName) && method.parameterNames.containsAll(parameterNames)) {
                    add = true;
                }
                log.log("Method " + method + (add ? " added to" : " removed from") + " search");
                if (!add) continue;
                set.add(method);
            }
        }
        if (set.size() >= 1) {
            MethodMetaModel method = set.iterator().next();
            log.log("Resolved method " + method.getName() + " " + method.getParameterNames() + " for " + methodName + " " + parameterNames + " among " + set);
            return method;
        }
        log.log("Could not resolve method " + methodName + " " + parameterNames + " among " + set);
        return null;
    }
}

