/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.meta;

import java.io.Serializable;
import org.juzu.impl.model.meta.MetaModelObject;

public class MetaModelEvent
implements Serializable {
    public static final int AFTER_ADD = 0;
    public static final int BEFORE_REMOVE = 1;
    public static final int UPDATED = 2;
    private final int type;
    private final MetaModelObject object;

    public static MetaModelEvent createAdded(MetaModelObject object) {
        return new MetaModelEvent(0, object);
    }

    public static MetaModelEvent createUpdated(MetaModelObject object) {
        return new MetaModelEvent(2, object);
    }

    public static MetaModelEvent createRemoved(MetaModelObject object) {
        return new MetaModelEvent(1, object);
    }

    MetaModelEvent(int type, MetaModelObject object) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.object = object;
    }

    public int getType() {
        return this.type;
    }

    public MetaModelObject getObject() {
        return this.object;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetaModelEvent) {
            MetaModelEvent that = (MetaModelEvent)obj;
            return this.type == that.type && this.object.equals(that.object);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.type + ",object=" + this.object.getClass().getSimpleName() + "]";
    }
}

