/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.processor;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.disk.DiskFileSystem;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.Spliterator;
import org.juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingContext
implements Filer,
Elements {
    private static final StandardLocation[] RESOURCE_LOCATIONS = new StandardLocation[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT};
    private ProcessingEnvironment env;
    private static final Logger log = BaseProcessor.getLogger(ProcessingContext.class);
    private final ReadFileSystem<File> sourcePath;

    public ProcessingContext(ProcessingEnvironment env) {
        DiskFileSystem sourcePath = null;
        try {
            ClassLoader cl = env.getClass().getClassLoader();
            Class<?> eclipseImplClass = cl.loadClass("org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl");
            if (eclipseImplClass.isInstance(env)) {
                File root;
                Spliterator split;
                Method getJavaProject = eclipseImplClass.getMethod("getJavaProject", new Class[0]);
                Object javaProject = getJavaProject.invoke((Object)env, new Object[0]);
                Class<?> aptConfigClass = cl.loadClass("org.eclipse.jdt.apt.core.util.AptConfig");
                Class<?> javaProjectClass = cl.loadClass("org.eclipse.jdt.core.IJavaProject");
                Method getProcessorOptionsMethod = aptConfigClass.getMethod("getProcessorOptions", javaProjectClass);
                Map options = (Map)getProcessorOptionsMethod.invoke(null, javaProject);
                log.log("Retrieved options " + options);
                String sp = (String)options.get("-sourcepath");
                log.log("Found sourcepath " + sp);
                if (sp != null && (split = new Spliterator(sp, ':')).hasNext() && (root = new File(split.next())).isDirectory()) {
                    sourcePath = new DiskFileSystem(root);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.log("Using processing " + env);
        log.log("Using source path " + sourcePath);
        this.env = env;
        this.sourcePath = sourcePath;
    }

    public <E extends Element> E get(ElementHandle<E> handle) {
        return handle.get(this.env);
    }

    public <T> T executeWithin(ElementHandle element, Callable<T> callable) throws CompilationException {
        return this.executeWithin((Element)element.get(this.env), callable);
    }

    public <T> T executeWithin(Element element, Callable<T> callable) throws CompilationException {
        try {
            return callable.call();
        }
        catch (CompilationException e) {
            if (e.getElement() != null) {
                throw e;
            }
            throw new CompilationException(element, e.getCode(), new Object[]{e.getArguments()});
        }
        catch (Exception e) {
            throw new CompilationException((Throwable)e, element, CompilationErrorCode.UNEXPECTED_ERROR, e.getMessage());
        }
    }

    public Content resolveResource(FQN fqn, String extension) {
        String path = "/" + fqn.getFullName().replace('.', '/') + "." + extension;
        if (this.sourcePath != null) {
            log.log("Attempt to resolve " + path + " from source path");
            try {
                ArrayList<String> list = new ArrayList<String>();
                Spliterator.split(fqn.getPackageName().getValue(), '.', list);
                list.add(fqn.getSimpleName() + "." + extension);
                File f = this.sourcePath.getPath(list);
                if (f != null) {
                    log.log("Resolved " + fqn + "." + extension + " to " + f.getAbsolutePath());
                    return this.sourcePath.getContent(f);
                }
                log.log("Resolving " + path + " from source path gave no result");
            }
            catch (IOException e) {
                log.log("Could not resolve " + path + " from source path", e);
            }
        } else {
            for (StandardLocation location : RESOURCE_LOCATIONS) {
                String pkg = fqn.getPackageName().getValue();
                String relativeName = fqn.getSimpleName() + "." + extension;
                try {
                    log.log("Attempt to resolve " + path + " from " + location.getName());
                    FileObject resource = this.getResource(location, pkg, relativeName);
                    byte[] bytes = Tools.bytes(resource.openInputStream());
                    return new Content(resource.getLastModified(), bytes, Charset.defaultCharset());
                }
                catch (Exception e) {
                    log.log("Could not resolve resource " + path + " from " + location.getName(), e);
                }
            }
        }
        return null;
    }

    public Element asElement(TypeMirror t) {
        return this.env.getTypeUtils().asElement(t);
    }

    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isSameType(t1, t2);
    }

    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isSubtype(t1, t2);
    }

    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isAssignable(t1, t2);
    }

    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().contains(t1, t2);
    }

    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.env.getTypeUtils().isSubsignature(m1, m2);
    }

    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.env.getTypeUtils().directSupertypes(t);
    }

    public TypeMirror erasure(TypeMirror t) {
        return this.env.getTypeUtils().erasure(t);
    }

    public TypeElement boxedClass(PrimitiveType p) {
        return this.env.getTypeUtils().boxedClass(p);
    }

    public PrimitiveType unboxedType(TypeMirror t) {
        return this.env.getTypeUtils().unboxedType(t);
    }

    public TypeMirror capture(TypeMirror t) {
        return this.env.getTypeUtils().capture(t);
    }

    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.env.getTypeUtils().getPrimitiveType(kind);
    }

    public NullType getNullType() {
        return this.env.getTypeUtils().getNullType();
    }

    public NoType getNoType(TypeKind kind) {
        return this.env.getTypeUtils().getNoType(kind);
    }

    public ArrayType getArrayType(TypeMirror componentType) {
        return this.env.getTypeUtils().getArrayType(componentType);
    }

    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.env.getTypeUtils().getWildcardType(extendsBound, superBound);
    }

    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.env.getTypeUtils().getDeclaredType(typeElem, typeArgs);
    }

    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.env.getTypeUtils().getDeclaredType(containing, typeElem, typeArgs);
    }

    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.env.getTypeUtils().asMemberOf(containing, element);
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.env.getElementUtils().getPackageElement(name);
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.env.getElementUtils().getTypeElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.env.getElementUtils().getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.env.getElementUtils().getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.env.getElementUtils().isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.env.getElementUtils().getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.env.getElementUtils().getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.env.getElementUtils().getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.env.getElementUtils().getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.env.getElementUtils().hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.env.getElementUtils().overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.env.getElementUtils().getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.env.getElementUtils().printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.env.getElementUtils().getName(cs);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        log.log("Creating source file for name=" + name + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createSourceFile(name, originatingElements);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        log.log("Creating class file for name=" + name + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createClassFile(name, originatingElements);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        log.log("Creating resource file for location=" + location + " pkg=" + pkg + " relativeName=" + relativeName + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createResource(location, pkg, relativeName, originatingElements);
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        return this.env.getFiler().getResource(location, pkg, relativeName);
    }
}

