/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.processor.ProcessingContext;
import org.juzu.impl.model.resolver.ModelResolver;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.ParseException;
import org.juzu.impl.template.compiler.ProcessContext;
import org.juzu.impl.template.compiler.ProcessPhase;
import org.juzu.impl.template.compiler.Template;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelTemplateProcessContext
extends ProcessContext {
    private TemplateMetaModel templateMetaModel;
    private final ProcessingContext env;
    private final Map<String, Template> templates;

    ModelTemplateProcessContext(TemplateMetaModel templateMetaModel, Map<String, Template> templates, ProcessingContext env) {
        this.templateMetaModel = templateMetaModel;
        this.env = env;
        this.templates = templates;
    }

    Collection<Template> resolve(final TemplateMetaModel metaModel) {
        ElementHandle.Field handle = this.templateMetaModel.getRefs().iterator().next().getHandle();
        return this.env.executeWithin(handle, new Callable<Collection<Template>>(){

            @Override
            public Collection<Template> call() throws Exception {
                HashSet keys = new HashSet(ModelTemplateProcessContext.this.templates.keySet());
                ProcessPhase phase = new ProcessPhase(ModelTemplateProcessContext.this, ModelTemplateProcessContext.this.templates);
                phase.resolveTemplate(metaModel.getPath());
                HashMap copy = new HashMap(ModelTemplateProcessContext.this.templates);
                copy.keySet().removeAll(keys);
                return copy.values();
            }
        });
    }

    protected Content resolveResource(FQN fqn, String extension) {
        return this.env.resolveResource(fqn, extension);
    }

    @Override
    protected Template resolveTemplate(String originPath, String path) {
        ASTNode.Template templateAST;
        Matcher matcher = ModelResolver.TEMPLATE_PATH_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new CompilationException(CompilationErrorCode.TEMPLATE_ILLEGAL_PATH, path);
        }
        String folder = matcher.group(1);
        String rawName = matcher.group(2);
        String extension = matcher.group(3);
        String fqn = this.templateMetaModel.getApplication().getTemplatesQN().getValue();
        for (String name : Spliterator.split(folder + rawName, '/')) {
            if (fqn.length() == 0) {
                fqn = name;
                continue;
            }
            fqn = fqn + "." + name;
        }
        FQN stubFQN = new FQN(fqn);
        Content content = this.resolveResource(stubFQN, extension);
        if (content == null) {
            throw new CompilationException(CompilationErrorCode.TEMPLATE_NOT_RESOLVED, fqn);
        }
        try {
            templateAST = ASTNode.Template.parse(content.getCharSequence());
        }
        catch (ParseException e) {
            throw new CompilationException(CompilationErrorCode.TEMPLATE_SYNTAX_ERROR, path);
        }
        return new Template(originPath, templateAST, stubFQN, extension, path, content.getLastModified());
    }
}

