/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.model.resolver;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.juzu.Path;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.compiler.ElementHandle;
import org.juzu.impl.inject.Export;
import org.juzu.impl.model.CompilationErrorCode;
import org.juzu.impl.model.meta.ApplicationMetaModel;
import org.juzu.impl.model.meta.MethodMetaModel;
import org.juzu.impl.model.meta.TemplateMetaModel;
import org.juzu.impl.model.meta.TemplateRefMetaModel;
import org.juzu.impl.model.resolver.ModelResolver;
import org.juzu.impl.model.resolver.ModelTemplateProcessContext;
import org.juzu.impl.spi.template.TemplateEmitter;
import org.juzu.impl.spi.template.TemplateProvider;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.compiler.EmitContext;
import org.juzu.impl.template.compiler.EmitPhase;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.ErrorCode;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.Logger;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.impl.utils.Tools;
import org.juzu.metadata.TemplateDescriptor;
import org.juzu.request.ApplicationContext;
import org.juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(TemplateResolver.class);
    private final ApplicationMetaModel application;
    private Map<String, org.juzu.impl.template.compiler.Template> templates;
    private Map<String, FileObject> resourceCache;
    private Map<FQN, FileObject> stubCache;
    private Map<FQN, FileObject> classCache;

    public TemplateResolver(ApplicationMetaModel application) {
        this.application = application;
        this.templates = new HashMap<String, org.juzu.impl.template.compiler.Template>();
        this.resourceCache = new HashMap<String, FileObject>();
        this.stubCache = new HashMap<FQN, FileObject>();
        this.classCache = new HashMap<FQN, FileObject>();
    }

    public Collection<org.juzu.impl.template.compiler.Template> getTemplates() {
        return this.templates.values();
    }

    void prePassivate() {
        log.log("Evicting cache " + this.resourceCache.keySet());
        this.resourceCache.clear();
        this.stubCache.clear();
        this.classCache.clear();
    }

    void process(ModelResolver context) throws CompilationException {
        log.log("Synchronizing existing templates " + this.templates.keySet());
        Iterator<org.juzu.impl.template.compiler.Template> i = this.templates.values().iterator();
        while (i.hasNext()) {
            org.juzu.impl.template.compiler.Template template = i.next();
            Content content = context.env.resolveResource(template.getFQN(), template.getExtension());
            if (content == null) {
                i.remove();
                log.log("Detected template removal " + template.getFQN());
                continue;
            }
            if (content.getLastModified() > template.getLastModified()) {
                i.remove();
                log.log("Detected stale template " + template.getFQN());
                continue;
            }
            log.log("Template " + template.getFQN() + " is valid");
        }
        log.log("Building missing templates");
        HashMap<String, org.juzu.impl.template.compiler.Template> copy = new HashMap<String, org.juzu.impl.template.compiler.Template>(this.templates);
        for (TemplateMetaModel templateMeta : this.application.getTemplates()) {
            org.juzu.impl.template.compiler.Template template = (org.juzu.impl.template.compiler.Template)copy.get(templateMeta.getPath());
            if (template != null) continue;
            log.log("Compiling template " + templateMeta.getPath());
            ModelTemplateProcessContext compiler = new ModelTemplateProcessContext(templateMeta, new HashMap<String, org.juzu.impl.template.compiler.Template>(copy), context.env);
            Collection<org.juzu.impl.template.compiler.Template> resolved = compiler.resolve(templateMeta);
            for (org.juzu.impl.template.compiler.Template added : resolved) {
                copy.put(added.getPath(), added);
            }
        }
        this.templates = copy;
        for (org.juzu.impl.template.compiler.Template template : this.templates.values()) {
            String originPath = template.getOriginPath();
            TemplateMetaModel templateMeta = this.application.getTemplate(originPath);
            LinkedHashSet<FQN> types = new LinkedHashSet<FQN>();
            for (TemplateRefMetaModel ref : templateMeta.getRefs()) {
                ElementHandle.Field handle = ref.getHandle();
                types.add(handle.getFQN());
            }
            Element[] elements = new Element[types.size()];
            int index = 0;
            for (FQN type : types) {
                elements[index++] = context.env.getTypeElement(type.getFullName());
            }
            this.resolveStub(template, context, elements);
            this.resolvedQualified(template, context, elements);
            this.resolveScript(template, context, elements);
        }
    }

    private void resolveScript(final org.juzu.impl.template.compiler.Template template, final ModelResolver context, final Element[] elements) {
        context.env.executeWithin(elements[0], new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() throws Exception {
                TemplateProvider provider = context.providers.get(template.getExtension());
                String key = template.getFQN().getFullName() + ".groovy";
                if (TemplateResolver.this.resourceCache.containsKey(key)) {
                    log.log("Template " + key + " was found in cache");
                    return null;
                }
                Writer writer = null;
                try {
                    try {
                        TemplateEmitter generator = provider.createEmitter();
                        ASTNode.Template ast = template.getAST();
                        EmitPhase tcc = new EmitPhase(new EmitContext(){

                            @Override
                            public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws CompilationException {
                                MethodMetaModel method = TemplateResolver.this.application.resolve(typeName, methodName, parameterMap.keySet());
                                if (method == null) {
                                    throw new CompilationException(CompilationErrorCode.CONTROLLER_METHOD_NOT_RESOLVED, methodName + "(" + parameterMap + ")");
                                }
                                ArrayList<String> args = new ArrayList<String>();
                                for (String parameterName : method.getParameterNames()) {
                                    String value = parameterMap.get(parameterName);
                                    args.add(value);
                                }
                                return new MethodInvocation(method.getController().getHandle().getFQN().getFullName() + "_", method.getName() + "URL", args);
                            }
                        });
                        tcc.emit(generator, ast);
                        FileObject scriptFile = context.env.createResource(StandardLocation.CLASS_OUTPUT, template.getFQN().getPackageName(), template.getFQN().getSimpleName() + "." + provider.getTargetExtension(), elements);
                        writer = scriptFile.openWriter();
                        writer.write(generator.toString());
                        TemplateResolver.this.resourceCache.put(key, scriptFile);
                        log.log("Generated template script " + template.getFQN().getFullName() + " as " + scriptFile.toUri() + " with originating elements " + Arrays.asList(elements));
                    }
                    catch (IOException e) {
                        throw new CompilationException((Throwable)e, (ErrorCode)CompilationErrorCode.CANNOT_WRITE_TEMPLATE_SCRIPT, template.getPath());
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Tools.safeClose(writer);
                    throw throwable;
                }
                Tools.safeClose(writer);
                return null;
            }
        });
    }

    private void resolvedQualified(org.juzu.impl.template.compiler.Template template, ModelResolver context, Element[] elements) {
        if (this.classCache.containsKey(template.getFQN())) {
            log.log("Template class " + template.getFQN() + " was found in cache");
            return;
        }
        Writer writer = null;
        try {
            try {
                JavaFileObject classFile = context.env.createSourceFile(template.getFQN().getFullName(), elements);
                writer = classFile.openWriter();
                writer.append("package ").append(template.getFQN().getPackageName()).append(";\n");
                writer.append("import ").append(Tools.getImport(Path.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Export.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
                writer.append("import ").append(Tools.getImport(TemplateDescriptor.class)).append(";\n");
                writer.append("import javax.inject.Inject;\n");
                writer.append("import ").append(Tools.getImport(ApplicationContext.class)).append(";\n");
                writer.append("@Generated({})\n");
                writer.append("@Export\n");
                writer.append("@Path(\"").append(template.getPath()).append("\")\n");
                writer.append("public class ").append(template.getFQN().getSimpleName()).append(" extends ").append(Template.class.getName()).append("\n");
                writer.append("{\n");
                writer.append("@Inject\n");
                writer.append("public ").append(template.getFQN().getSimpleName()).append("(").append(ApplicationContext.class.getSimpleName()).append(" applicationContext").append(")\n");
                writer.append("{\n");
                writer.append("super(applicationContext, \"").append(template.getPath()).append("\");\n");
                writer.append("}\n");
                writer.append("public static final TemplateDescriptor DESCRIPTOR = new TemplateDescriptor(").append(template.getFQN().getFullName()).append(".class);\n");
                if (template.getParameters() != null) {
                    for (String paramName : template.getParameters()) {
                        writer.append("public Builder ").append(paramName).append("(Object ").append(paramName).append(") {\n");
                        writer.append("Builder builder = new Builder();");
                        writer.append("builder.set(\"").append(paramName).append("\",").append(paramName).append(");\n");
                        writer.append("return builder;\n");
                        writer.append("}\n");
                    }
                    writer.append("public class Builder extends ").append(Tools.getImport(Template.Builder.class)).append("\n");
                    writer.append("{\n");
                    for (String paramName : template.getParameters()) {
                        writer.append("public Builder ").append(paramName).append("(Object ").append(paramName).append(") {\n");
                        writer.append("set(\"").append(paramName).append("\",").append(paramName).append(");\n");
                        writer.append("return this;\n");
                        writer.append("}\n");
                    }
                    writer.append("}\n");
                }
                writer.append("}\n");
                this.classCache.put(template.getFQN(), classFile);
                log.log("Generated template class " + template.getFQN().getFullName() + " as " + classFile.toUri() + " with originating elements " + Arrays.asList(elements));
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, elements[0], CompilationErrorCode.CANNOT_WRITE_TEMPLATE_CLASS, template.getPath());
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }

    private void resolveStub(org.juzu.impl.template.compiler.Template template, ModelResolver context, Element[] elements) {
        if (this.stubCache.containsKey(template.getFQN())) {
            log.log("Template strub " + template.getFQN() + " was found in cache");
            return;
        }
        FQN stubFQN = new FQN(template.getFQN().getFullName() + "_");
        TemplateProvider provider = context.providers.get(template.getExtension());
        Writer writer = null;
        try {
            try {
                JavaFileObject stubFile = context.env.createSourceFile(stubFQN.getFullName(), elements);
                writer = stubFile.openWriter();
                writer.append("package ").append(stubFQN.getPackageName()).append(";\n");
                writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
                writer.append("@Generated({\"").append(stubFQN.getFullName()).append("\"})\n");
                writer.append("public class ").append(stubFQN.getSimpleName()).append(" extends ").append(provider.getTemplateStubType().getName()).append(" {\n");
                writer.append("}");
                this.stubCache.put(template.getFQN(), stubFile);
                log.log("Generating template stub " + stubFQN.getFullName() + " as " + stubFile.toUri() + " with originating elements " + Arrays.asList(elements));
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, elements[0], CompilationErrorCode.CANNOT_WRITE_TEMPLATE_STUB, template.getPath());
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }
}

