/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.request;

import org.juzu.impl.inject.ScopingContext;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.request.ActionBridge;
import org.juzu.impl.spi.request.RenderBridge;
import org.juzu.impl.spi.request.RequestBridge;
import org.juzu.impl.spi.request.ResourceBridge;
import org.juzu.metadata.ControllerMethod;
import org.juzu.request.ActionContext;
import org.juzu.request.ApplicationContext;
import org.juzu.request.RenderContext;
import org.juzu.request.RequestContext;
import org.juzu.request.ResourceContext;

public class Request
implements ScopingContext {
    private final RequestBridge bridge;
    private final RequestContext context;

    public Request(ApplicationContext application, ControllerMethod method, ClassLoader classLoader, RequestBridge bridge) {
        RequestContext context = bridge instanceof RenderBridge ? new RenderContext(application, method, classLoader, (RenderBridge)bridge) : (bridge instanceof ActionBridge ? new ActionContext(method, classLoader, (ActionBridge)bridge) : new ResourceContext(application, method, classLoader, (ResourceBridge)bridge));
        this.context = context;
        this.bridge = bridge;
    }

    public RequestContext getContext() {
        return this.context;
    }

    public final Object getContextualValue(Scope scope, Object key) {
        switch (scope) {
            case FLASH: {
                return this.bridge.getFlashValue(key);
            }
            case REQUEST: {
                return this.bridge.getRequestValue(key);
            }
            case SESSION: {
                return this.bridge.getSessionValue(key);
            }
            case IDENTITY: {
                return this.bridge.getIdentityValue(key);
            }
        }
        throw new AssertionError();
    }

    public final void setContextualValue(Scope scope, Object key, Object value) {
        switch (scope) {
            case FLASH: {
                this.bridge.setFlashValue(key, value);
                break;
            }
            case REQUEST: {
                this.bridge.setRequestValue(key, value);
                break;
            }
            case SESSION: {
                this.bridge.setSessionValue(key, value);
                break;
            }
            case IDENTITY: {
                this.bridge.setIdentityValue(key, value);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean isActive(Scope scope) {
        return scope.isActive(this);
    }
}

