/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.cdi;

import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.juzu.impl.inject.Export;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.cdi.AbstractBean;
import org.juzu.impl.spi.inject.cdi.CDIManager;
import org.juzu.impl.spi.inject.cdi.Container;
import org.juzu.impl.spi.inject.cdi.ContextImpl;
import org.juzu.impl.spi.inject.cdi.InstanceBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private final CDIManager manager = CDIManager.boot.get();

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class type = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Export.class) && !this.manager.declaredBeans.contains(type)) {
            pat.veto();
        }
        for (Class<?> boundBeanType : this.manager.boundBeans.keySet()) {
            if (!boundBeanType.isAssignableFrom(type)) continue;
            pat.veto();
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        Container container = Container.boot.get();
        for (Scope scope : container.scopes) {
            event.addContext((Context)new ContextImpl(container.scopeController, scope, scope.getAnnotationType()));
        }
        event.addBean((Bean)new InstanceBean(InjectManager.class, this.manager));
        for (AbstractBean bean : this.manager.boundBeans.values()) {
            event.addBean((Bean)bean);
        }
    }
}

