/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevClassLoader
extends ClassLoader {
    public DevClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String classPath;
        URL url;
        Class<?> found = super.loadClass(name, resolve);
        if (found.getClassLoader() == super.getParent() && (url = this.getResource(classPath = name.replace('.', '/') + ".class")) == null) {
            throw new ClassNotFoundException();
        }
        return found;
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null && this.shouldLoad(url, name)) {
            return url;
        }
        try {
            Enumeration<URL> e = this.getResources(name);
            if (e.hasMoreElements()) {
                return e.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        final Enumeration<URL> a = super.getResources(name);
        return new Enumeration<URL>(){
            URL next = null;

            @Override
            public boolean hasMoreElements() {
                while (this.next == null && a.hasMoreElements()) {
                    URL url = (URL)a.nextElement();
                    if (!DevClassLoader.this.shouldLoad(url, name)) continue;
                    this.next = url;
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public URL nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("No more elements");
                }
                try {
                    URL uRL = this.next;
                    Object var3_2 = null;
                    this.next = null;
                    return uRL;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.next = null;
                    throw throwable;
                }
            }
        };
    }

    private boolean shouldLoad(URL url, String name) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            String path = url.getPath();
            return !path.endsWith("/WEB-INF/classes/" + name);
        }
        if ("jar".equals(protocol)) {
            int index;
            String path = url.getPath();
            String nested = path.substring(0, index = path.indexOf("!/"));
            if (nested.endsWith(".jar")) {
                return true;
            }
            throw new UnsupportedOperationException("handle me gracefully " + url);
        }
        throw new UnsupportedOperationException("handle me gracefully " + url);
    }
}

