/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableArray<E>
implements Iterable<E> {
    private final E[] elements;
    private final int from;
    private final int to;

    public IterableArray(E[] elements, int from, int to) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
        if (elements == null) {
            throw new NullPointerException("No null elements accepted");
        }
        if (from < 0) {
            throw new IndexOutOfBoundsException("From index cannot be negative");
        }
        if (to > elements.length + 1) {
            throw new IndexOutOfBoundsException("To index cannot be greater than the array size + 1");
        }
        if (from > to) {
            throw new IllegalArgumentException("From index cannot be greater than the to index");
        }
        this.elements = elements;
        this.from = from;
        this.to = to;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int current;
            {
                this.current = IterableArray.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.current < IterableArray.this.to;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IterableArray.this.elements[this.current++];
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

