/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.request;

import java.util.List;
import org.juzu.Response;
import org.juzu.impl.spi.request.ActionBridge;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.ControllerParameter;
import org.juzu.request.Phase;
import org.juzu.request.RequestContext;

public class ActionContext
extends RequestContext {
    private ActionBridge bridge;
    private boolean sent;

    protected ActionContext() {
    }

    public ActionContext(ControllerMethod method, ClassLoader classLoader, ActionBridge bridge) {
        super(method, classLoader);
        this.bridge = bridge;
        this.sent = false;
    }

    protected ActionBridge getBridge() {
        return this.bridge;
    }

    public Phase getPhase() {
        return Phase.ACTION;
    }

    public Response.Redirect redirect(String location) {
        return this.bridge.redirect(location);
    }

    public boolean isSent() {
        return this.sent;
    }

    public Response.Render createResponse(ControllerMethod method) throws IllegalStateException {
        if (this.sent) {
            throw new IllegalStateException("Response already created");
        }
        Response.Render response = this.bridge.createResponse(method);
        this.sent = true;
        return response;
    }

    public Response.Render createResponse(ControllerMethod method, Object arg) throws IllegalStateException {
        Response.Render response = this.createResponse(method);
        List<ControllerParameter> argumentParameters = method.getArgumentParameters();
        if (arg != null) {
            response.setParameter(argumentParameters.get(0).getName(), arg.toString());
        }
        return response;
    }

    public Response.Render createResponse(ControllerMethod method, Object[] args) throws IllegalStateException {
        Response.Render response = this.createResponse(method);
        List<ControllerParameter> argumentParameters = method.getArgumentParameters();
        for (int i = 0; i < argumentParameters.size(); ++i) {
            Object value = args[i];
            if (value == null) continue;
            ControllerParameter argParameter = argumentParameters.get(i);
            response.setParameter(argParameter.getName(), value.toString());
        }
        return response;
    }
}

