/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.request;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.juzu.URLBuilder;
import org.juzu.impl.spi.request.MimeBridge;
import org.juzu.metadata.ApplicationDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.ControllerParameter;
import org.juzu.request.ApplicationContext;
import org.juzu.request.RequestContext;
import org.juzu.text.Printer;

public abstract class MimeContext
extends RequestContext {
    private final ApplicationContext application;

    protected MimeContext(ApplicationContext application, ControllerMethod method, ClassLoader classLoader) {
        super(method, classLoader);
        this.application = application;
    }

    protected abstract MimeBridge getBridge();

    public URLBuilder createURLBuilder(ControllerMethod method) {
        URLBuilder builder = this.getBridge().createURLBuilder(method);
        ApplicationDescriptor desc = this.application.getDescriptor();
        builder.escapeXML(desc.getEscapeXML());
        return builder;
    }

    private void setValue(URLBuilder builder, ControllerParameter param, Object value) {
        switch (param.getCardinality()) {
            case SINGLE: {
                builder.setParameter(param.getName(), String.valueOf(value));
                break;
            }
            case ARRAY: {
                int length = Array.getLength(value);
                String[] array = new String[length];
                for (int i = 0; i < length; ++i) {
                    Object component = Array.get(value, i);
                    array[i] = String.valueOf(component);
                }
                builder.setParameter(param.getName(), array);
                break;
            }
            case LIST: {
                Collection c = (Collection)value;
                int length = c.size();
                String[] array = new String[length];
                Iterator iterator = c.iterator();
                for (int i = 0; i < length; ++i) {
                    Object element = iterator.next();
                    array[i] = String.valueOf(element);
                }
                builder.setParameter(param.getName(), array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
    }

    public URLBuilder createURLBuilder(ControllerMethod method, Object arg) {
        URLBuilder builder = this.createURLBuilder(method);
        ControllerParameter param = method.getArgumentParameters().get(0);
        if (arg != null) {
            this.setValue(builder, param, arg);
        }
        return builder;
    }

    public URLBuilder createURLBuilder(ControllerMethod method, Object[] args) {
        URLBuilder builder = this.createURLBuilder(method);
        for (int i = 0; i < args.length; ++i) {
            Object value = args[i];
            if (value == null) continue;
            this.setValue(builder, method.getArgumentParameters().get(i), value);
        }
        return builder;
    }

    public Printer getPrinter() {
        return this.getBridge().getPrinter();
    }
}

