/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.template;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.juzu.UndeclaredIOException;
import org.juzu.request.ApplicationContext;
import org.juzu.template.TemplateExecutionException;
import org.juzu.text.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private final String path;
    private final ApplicationContext applicationContext;

    public Template(ApplicationContext applicationContext, String path) {
        this.applicationContext = applicationContext;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void render() throws TemplateExecutionException, UndeclaredIOException {
        this.render(Collections.emptyMap(), null);
    }

    public void render(Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.render(Collections.emptyMap(), locale);
    }

    public void render(Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.render(parameters, null);
    }

    public void render(Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.render(null, parameters, null);
    }

    public void render(Printer printer) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, Collections.emptyMap(), null);
    }

    public void render(Printer printer, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, Collections.emptyMap(), locale);
    }

    public void render(Printer printer, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.render(printer, parameters, null);
    }

    public void render(Printer printer, Map<String, ?> attributes, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        try {
            this.applicationContext.render(this, printer, attributes, locale);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[path=" + this.path + "]";
    }

    public abstract class Builder {
        private Map<String, Object> parameters;

        public final void render() {
            if (this.parameters != null) {
                Template.this.render(this.parameters);
            } else {
                Template.this.render();
            }
        }

        public Builder set(String name, Object value) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException("The parameter argument cannot be null");
            }
            if (value != null) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Object>();
                }
                this.parameters.put(name, value);
            } else if (this.parameters != null) {
                this.parameters.remove(name);
            }
            return this;
        }
    }
}

