/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.processor;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.juzu.AmbiguousResolutionException;
import org.juzu.impl.processor.ControllerModel;
import org.juzu.impl.processor.ElementHandle;
import org.juzu.impl.processor.MethodModel;
import org.juzu.impl.processor.TemplateModel;
import org.juzu.impl.utils.FQN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationModel
implements Serializable {
    final ElementHandle origin;
    final FQN fqn;
    final String defaultController;
    final LinkedHashMap<String, ControllerModel> controllers;
    final String templatesFQN;
    final LinkedHashMap<String, TemplateModel> templates;

    public ApplicationModel(ElementHandle origin, FQN fqn, String defaultController, String templatesFQN) {
        this.origin = origin;
        this.defaultController = defaultController;
        this.fqn = fqn;
        this.controllers = new LinkedHashMap();
        this.templatesFQN = templatesFQN;
        this.templates = new LinkedHashMap();
    }

    public MethodModel resolve(String typeName, String methodName, Set<String> parameterNames) throws AmbiguousResolutionException {
        TreeSet<MethodModel> set = new TreeSet<MethodModel>(new Comparator<MethodModel>(){

            @Override
            public int compare(MethodModel o1, MethodModel o2) {
                return Integer.valueOf(o1.parameterNames.size()).compareTo(o2.parameterNames.size());
            }
        });
        for (ControllerModel controller : this.controllers.values()) {
            for (MethodModel method : controller.methods) {
                if (typeName != null && !controller.fqn.getSimpleName().equals(typeName) || !method.name.equals(methodName) || !method.parameterNames.containsAll(parameterNames)) continue;
                set.add(method);
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }
}

