/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.processor;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.processor.ElementHandle;
import org.juzu.impl.processor.ErrorCode;
import org.juzu.impl.processor.MainProcessor;

public class Foo
implements Serializable {
    public static final Pattern NAME_PATTERN = Pattern.compile("([^/].*/|)([^./]+)\\.([a-zA-Z]+)");
    private final ElementHandle origin;
    private final String originPackageFQN;
    private final String path;
    private final String folder;
    private final String rawName;
    private final String extension;

    public Foo(Foo that, String path) {
        this(that.origin, that.originPackageFQN, path);
    }

    public Foo(Element origin, String originPackageFQN, String path) {
        this(ElementHandle.create(origin), originPackageFQN, path);
    }

    private Foo(ElementHandle origin, String originPackageFQN, String path) {
        Matcher matcher = NAME_PATTERN.matcher(path);
        if (!matcher.matches()) {
            throw new CompilationException(MainProcessor.get(origin), ErrorCode.ILLEGAL_PATH, path);
        }
        this.origin = origin;
        this.originPackageFQN = originPackageFQN;
        this.path = path;
        this.folder = matcher.group(1);
        this.rawName = matcher.group(2);
        this.extension = matcher.group(3);
    }

    public ElementHandle getOrigin() {
        return this.origin;
    }

    public String getOriginPackageFQN() {
        return this.originPackageFQN;
    }

    public String getPath() {
        return this.path;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getRawName() {
        return this.rawName;
    }

    public String getExtension() {
        return this.extension;
    }
}

