/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.juzu.Path;
import org.juzu.Phase;
import org.juzu.Response;
import org.juzu.URLBuilder;
import org.juzu.impl.application.InternalApplicationContext;
import org.juzu.impl.compiler.BaseProcessor;
import org.juzu.impl.compiler.CompilationException;
import org.juzu.impl.inject.Export;
import org.juzu.impl.processor.ApplicationModel;
import org.juzu.impl.processor.ControllerModel;
import org.juzu.impl.processor.ElementHandle;
import org.juzu.impl.processor.ErrorCode;
import org.juzu.impl.processor.Foo;
import org.juzu.impl.processor.MethodModel;
import org.juzu.impl.processor.Model;
import org.juzu.impl.processor.TemplateCompiler;
import org.juzu.impl.processor.TemplateModel;
import org.juzu.impl.spi.template.TemplateGenerator;
import org.juzu.impl.spi.template.TemplateProvider;
import org.juzu.impl.template.ASTNode;
import org.juzu.impl.template.TemplateCompilationContext;
import org.juzu.impl.utils.FQN;
import org.juzu.impl.utils.MethodInvocation;
import org.juzu.impl.utils.Tools;
import org.juzu.metadata.ApplicationDescriptor;
import org.juzu.metadata.ControllerDescriptor;
import org.juzu.metadata.ControllerMethod;
import org.juzu.metadata.ControllerParameter;
import org.juzu.request.ActionContext;
import org.juzu.request.ApplicationContext;
import org.juzu.request.MimeContext;
import org.juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"foobar"})
@SupportedAnnotationTypes(value={"org.juzu.View", "org.juzu.Action", "org.juzu.Resource", "org.juzu.Application", "org.juzu.Path"})
public class MainProcessor
extends BaseProcessor {
    private static final String RESPONSE = Response.Render.class.getSimpleName();
    private static final String PHASE = Phase.class.getSimpleName();
    private static final String CONTROLLER_METHOD = ControllerMethod.class.getSimpleName();
    private static final String CONTROLLER_DESCRIPTOR = ControllerDescriptor.class.getSimpleName();
    private static final String TOOLS = Tools.class.getSimpleName();
    private static final String CONTROLLER_PARAMETER = ControllerParameter.class.getSimpleName();
    private static final String APPLICATION_DESCRIPTOR = ApplicationDescriptor.class.getSimpleName();
    private static final Pattern PROVIDER_PKG_PATTERN = Pattern.compile("org\\.juzu\\.impl\\.spi\\.template\\.([^.]+)(?:\\..+)?");
    private static final ThreadLocal<ProcessingEnvironment> env = new ThreadLocal();
    private Model model;
    Filer filer;
    private Map<String, TemplateProvider> providers;

    static Element get(ElementHandle handle) {
        return handle.get(env.get());
    }

    @Override
    protected void doInit(ProcessingEnvironment processingEnv) {
        ServiceLoader<TemplateProvider> loader = ServiceLoader.load(TemplateProvider.class, TemplateProvider.class.getClassLoader());
        HashMap<String, TemplateProvider> providers = new HashMap<String, TemplateProvider>();
        for (TemplateProvider provider : loader) {
            String pkgName = provider.getClass().getPackage().getName();
            Matcher matcher = PROVIDER_PKG_PATTERN.matcher(pkgName);
            if (!matcher.matches()) continue;
            String extension = matcher.group(1);
            providers.put(extension, provider);
        }
        this.providers = providers;
        this.filer = processingEnv.getFiler();
        String options = processingEnv.getOptions().toString();
        MainProcessor.log("using processing nev " + processingEnv.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            block20: {
                env.set(this.processingEnv);
                if (!roundEnv.errorRaised()) {
                    if (roundEnv.processingOver()) {
                        this.emitTemplates();
                        this.emitConfig();
                        ObjectOutputStream out = null;
                        try {
                            try {
                                FileObject fileObject = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "model.ser", new Element[0]);
                                out = new ObjectOutputStream(fileObject.openOutputStream());
                                out.writeObject(this.model);
                                this.model = null;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                Object var6_13 = null;
                                Tools.safeClose(out);
                                break block20;
                            }
                            Object var6_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_14 = null;
                            Tools.safeClose(out);
                            throw throwable;
                        }
                        Tools.safeClose(out);
                    } else {
                        block21: {
                            if (this.model == null) {
                                InputStream in = null;
                                try {
                                    try {
                                        FileObject fileObject = this.filer.getResource(StandardLocation.SOURCE_OUTPUT, "org.juzu", "model.ser");
                                        in = fileObject.openInputStream();
                                        ObjectInputStream ois = new ObjectInputStream(in);
                                        this.model = (Model)ois.readObject();
                                    }
                                    catch (Exception exception) {
                                        this.model = new Model();
                                        Object var8_19 = null;
                                        Tools.safeClose(in);
                                        break block21;
                                    }
                                    Object var8_18 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var8_20 = null;
                                    Tools.safeClose(in);
                                    throw throwable;
                                }
                                Tools.safeClose(in);
                            }
                        }
                        for (TypeElement typeElement : annotations) {
                            block11: for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                                if (element.getAnnotation(Generated.class) != null) continue;
                                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                                    if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(typeElement)) continue;
                                    String annotationName = typeElement.getSimpleName().toString();
                                    HashMap<String, Object> annotationValues = new HashMap<String, Object>();
                                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                        String m = entry.getKey().getSimpleName().toString();
                                        Object value = entry.getValue().getValue();
                                        annotationValues.put(m, value);
                                    }
                                    String annotationFQN = typeElement.getQualifiedName().toString();
                                    if (annotationFQN.equals("org.juzu.View") || annotationFQN.equals("org.juzu.Action") || annotationFQN.equals("org.juzu.Resource")) {
                                        this.processController(annotationName, annotationValues, element);
                                        continue block11;
                                    }
                                    if (annotationFQN.equals("org.juzu.Path")) {
                                        this.processTemplate(annotationName, annotationValues, element);
                                        continue block11;
                                    }
                                    if (!annotationFQN.equals("org.juzu.Application")) continue block11;
                                    this.processApplication(annotationName, annotationValues, element);
                                    continue block11;
                                }
                            }
                        }
                        this.resolveControllers();
                        this.resolveTemplates();
                    }
                }
            }
            Object var16_32 = null;
            env.set(null);
            return;
        }
        catch (Throwable throwable) {
            Object var16_33 = null;
            env.set(null);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emitConfig() {
        Properties config = new Properties();
        for (ApplicationModel application : this.model.applications.values()) {
            config.put(application.fqn.getSimpleName(), application.fqn.getFullName());
        }
        Writer writer = null;
        try {
            try {
                FileObject fo = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "org.juzu", "config.properties", new Element[0]);
                writer = fo.openWriter();
                config.store(writer, null);
            }
            catch (IOException e) {
                throw new CompilationException((Throwable)e, ErrorCode.CANNOT_WRITE_CONFIG, new Object[0]);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
        Iterator<ApplicationModel> i$ = this.model.applications.values().iterator();
        while (i$.hasNext()) {
            Object var8_11;
            ApplicationModel application = i$.next();
            config = new Properties();
            for (ControllerModel controller : application.controllers.values()) {
                config.put(controller.fqn.getFullName() + "_", "controller");
            }
            for (TemplateModel template : application.templates.values()) {
                config.put(template.getStubFQN().getFullName() + "_", "template");
            }
            writer = null;
            try {
                try {
                    FileObject fo = this.filer.createResource(StandardLocation.CLASS_OUTPUT, application.fqn.getPackageName(), "config.properties", new Element[0]);
                    writer = fo.openWriter();
                    config.store(writer, null);
                }
                catch (IOException e) {
                    throw new CompilationException((Throwable)e, application.origin.get(this.processingEnv), ErrorCode.CANNOT_WRITE_APPLICATION_CONFIG, new Object[0]);
                }
                var8_11 = null;
            }
            catch (Throwable throwable) {
                var8_11 = null;
                Tools.safeClose(writer);
                throw throwable;
            }
            Tools.safeClose(writer);
        }
        return;
    }

    private void emitTemplates() {
        for (final ApplicationModel application : this.model.applications.values()) {
            for (final TemplateModel template : application.templates.values()) {
                TemplateProvider provider = this.providers.get(template.getFoo().getExtension());
                try {
                    TemplateGenerator generator = provider.newGenerator();
                    ASTNode.Template ast = template.getAST();
                    ast.emit(new TemplateCompilationContext(){

                        @Override
                        public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) {
                            MethodModel method = application.resolve(typeName, methodName, parameterMap.keySet());
                            if (method == null) {
                                throw new CompilationException(template.getFoo().getOrigin().get(MainProcessor.this.processingEnv), ErrorCode.CONTROLLER_METHOD_NOT_FOUND, methodName, parameterMap);
                            }
                            ArrayList<String> args = new ArrayList<String>();
                            for (String parameterName : method.parameterNames) {
                                String value = parameterMap.get(parameterName);
                                args.add(value);
                            }
                            return new MethodInvocation(method.controller.fqn + "_", method.name + "URL", args);
                        }
                    }, generator);
                    generator.generate(this.filer, template.getStubFQN().getPackageName(), template.getStubFQN().getSimpleName());
                }
                catch (IOException e) {
                    throw new CompilationException(template.getFoo().getOrigin().get(this.processingEnv), ErrorCode.CANNOT_WRITE_TEMPLATE, new Object[0]);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveControllers() {
        Iterator<Map.Entry<String, ControllerModel>> i = this.model.controllers.entrySet().iterator();
        block12: while (i.hasNext()) {
            Map.Entry<String, ControllerModel> controllerEntry = i.next();
            Iterator<Map.Entry<String, ApplicationModel>> i$ = this.model.applications.entrySet().iterator();
            while (true) {
                Object var15_18;
                if (!i$.hasNext()) continue block12;
                Map.Entry<String, ApplicationModel> applicationEntry = i$.next();
                if (!controllerEntry.getKey().startsWith(applicationEntry.getKey() + ".")) continue;
                i.remove();
                ApplicationModel application = applicationEntry.getValue();
                ControllerModel controller = controllerEntry.getValue();
                application.controllers.put(controllerEntry.getKey(), controller);
                Element origin = controller.origin.get(this.processingEnv);
                Writer writer = null;
                try {
                    try {
                        JavaFileObject applicationFile = this.filer.createSourceFile(controller.fqn.getFullName() + "_", origin);
                        writer = applicationFile.openWriter();
                        writer.append("package ").append(controller.fqn.getPackageName()).append(";\n");
                        writer.append("import ").append(Tools.getImport(ControllerMethod.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(ControllerParameter.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(Tools.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(Arrays.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(Phase.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(URLBuilder.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(InternalApplicationContext.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(MimeContext.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(ActionContext.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(Response.Render.class)).append(";\n");
                        writer.append("import ").append(Tools.getImport(ControllerDescriptor.class)).append(";\n");
                        writer.append("public class ").append(controller.fqn.getSimpleName()).append("_ extends ").append(CONTROLLER_DESCRIPTOR).append(" {\n");
                        writer.append("private ").append(controller.fqn.getSimpleName()).append("_() {\n");
                        writer.append("super(").append(controller.fqn.getSimpleName()).append(".class, Arrays.<").append(CONTROLLER_METHOD).append(">asList(");
                        for (int j = 0; j < controller.methods.size(); ++j) {
                            MethodModel method = controller.methods.get(j);
                            if (j > 0) {
                                writer.append(',');
                            }
                            writer.append(method.id);
                        }
                        writer.append("));\n");
                        writer.append("}\n");
                        for (MethodModel method : controller.methods) {
                            int j;
                            writer.append("private static final ").append(CONTROLLER_METHOD).append(" ").append(method.id).append(" = ");
                            writer.append("new ").append(CONTROLLER_METHOD).append("(");
                            writer.append("\"").append(method.id).append("\",");
                            writer.append(PHASE).append(".").append(method.phase.name()).append(",");
                            writer.append(controller.fqn.getFullName()).append(".class").append(",");
                            writer.append(TOOLS).append(".safeGetMethod(").append(controller.fqn.getFullName()).append(".class,\"").append(method.name).append("\"");
                            for (String parameterType : method.parameterTypes) {
                                writer.append(",").append(parameterType).append(".class");
                            }
                            writer.append(")");
                            writer.append(", Arrays.<").append(CONTROLLER_PARAMETER).append(">asList(");
                            Iterator<String> j2 = method.parameterNames.iterator();
                            while (j2.hasNext()) {
                                String parameterName = j2.next();
                                writer.append("new ").append(CONTROLLER_PARAMETER).append("(\"").append(parameterName).append("\")");
                                if (!j2.hasNext()) continue;
                                writer.append(",");
                            }
                            writer.append(")");
                            writer.append(");\n");
                            if (method.phase == Phase.RENDER) {
                                int j3;
                                writer.append("public static ").append(RESPONSE).append(" ").append(method.name).append("(");
                                for (j3 = 0; j3 < method.parameterTypes.size(); ++j3) {
                                    if (j3 > 0) {
                                        writer.append(',');
                                    }
                                    writer.append(method.parameterTypes.get(j3)).append(" ").append(method.parameterNames.get(j3));
                                }
                                writer.append(") { return ((ActionContext)InternalApplicationContext.getCurrentRequest()).createResponse(").append(method.id);
                                switch (method.parameterTypes.size()) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        writer.append(",(Object)").append(method.parameterNames.get(0));
                                        break;
                                    }
                                    default: {
                                        writer.append(",new Object[]{");
                                        for (j3 = 0; j3 < method.parameterNames.size(); ++j3) {
                                            if (j3 > 0) {
                                                writer.append(",");
                                            }
                                            writer.append(method.parameterNames.get(j3));
                                        }
                                        writer.append("}");
                                    }
                                }
                                writer.append("); }\n");
                            }
                            writer.append("public static URLBuilder ").append(method.name).append("URL").append("(");
                            for (j = 0; j < method.parameterTypes.size(); ++j) {
                                if (j > 0) {
                                    writer.append(',');
                                }
                                writer.append(method.parameterTypes.get(j)).append(" ").append(method.parameterNames.get(j));
                            }
                            writer.append(") { return ((MimeContext)InternalApplicationContext.getCurrentRequest()).createURLBuilder(").append(method.id);
                            switch (method.parameterNames.size()) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    writer.append(",(Object)").append(method.parameterNames.get(0));
                                    break;
                                }
                                default: {
                                    writer.append(",new Object[]{");
                                    for (j = 0; j < method.parameterNames.size(); ++j) {
                                        if (j > 0) {
                                            writer.append(",");
                                        }
                                        writer.append(method.parameterNames.get(j));
                                    }
                                    writer.append("}");
                                }
                            }
                            writer.append("); }\n");
                        }
                        writer.append("public static final ").append(controller.fqn.getSimpleName()).append("_ INSTANCE = new ").append(controller.fqn.getSimpleName()).append("_();\n");
                        writer.append("}\n");
                    }
                    catch (IOException e) {
                        throw new CompilationException((Throwable)e, origin, ErrorCode.CANNOT_WRITE_CONTROLLER_CLASS, new Object[0]);
                    }
                    var15_18 = null;
                }
                catch (Throwable throwable) {
                    var15_18 = null;
                    Tools.safeClose(writer);
                    throw throwable;
                }
                Tools.safeClose(writer);
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void resolveTemplates() {
        Iterator<Foo> i = this.model.templates.iterator();
        block12: while (i.hasNext()) {
            Foo foo = i.next();
            for (Map.Entry<String, ApplicationModel> applicationEntry : this.model.applications.entrySet()) {
                TemplateCompiler compiler;
                if (!foo.getOriginPackageFQN().equals(applicationEntry.getKey()) && !foo.getOriginPackageFQN().startsWith(applicationEntry.getKey() + ".")) continue;
                i.remove();
                ApplicationModel application = applicationEntry.getValue();
                String path = foo.getPath();
                try {
                    compiler = new TemplateCompiler(application, foo, this);
                    compiler.resolveTemplate(path);
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException("handle me gracefully: could not process template " + path);
                }
                for (TemplateModel template : compiler.getAdded()) {
                    Object var19_21;
                    Object var15_19;
                    FQN stubFQN;
                    TemplateProvider provider = this.providers.get(template.getFoo().getExtension());
                    Writer stubWriter = null;
                    try {
                        try {
                            stubFQN = template.getStubFQN();
                            JavaFileObject stubFile = this.filer.createSourceFile(stubFQN.getFullName(), new Element[0]);
                            stubWriter = stubFile.openWriter();
                            stubWriter.append("package ").append(stubFQN.getPackageName()).append(";\n");
                            stubWriter.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
                            stubWriter.append("@Generated({})\n");
                            stubWriter.append("public class ").append(stubFQN.getSimpleName()).append(" extends ").append(provider.getTemplateStubType().getName()).append(" {\n");
                            stubWriter.append("}");
                        }
                        catch (IOException e) {
                            throw new CompilationException((Throwable)e, template.getFoo().getOrigin().get(this.processingEnv), ErrorCode.CANNOT_WRITE_TEMPLATE_STUB_CLASS, template.getFoo().getPath());
                        }
                        var15_19 = null;
                    }
                    catch (Throwable throwable) {
                        var15_19 = null;
                        Tools.safeClose(stubWriter);
                        throw throwable;
                    }
                    Tools.safeClose(stubWriter);
                    Writer classWriter = null;
                    try {
                        Object var17_20;
                        JavaFileObject classFile = this.filer.createSourceFile(stubFQN.getFullName() + "_", new Element[0]);
                        classWriter = classFile.openWriter();
                        try {
                            classWriter.append("package ").append(stubFQN.getPackageName()).append(";\n");
                            classWriter.append("import ").append(Tools.getImport(Path.class)).append(";\n");
                            classWriter.append("import ").append(Tools.getImport(Export.class)).append(";\n");
                            classWriter.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
                            classWriter.append("import javax.inject.Inject;\n");
                            classWriter.append("import ").append(Tools.getImport(ApplicationContext.class)).append(";\n");
                            classWriter.append("@Generated({})\n");
                            classWriter.append("@Export\n");
                            classWriter.append("@Path(\"").append(template.getFoo().getPath()).append("\")\n");
                            classWriter.append("public class ").append(stubFQN.getSimpleName()).append("_ extends ").append(Template.class.getName()).append("\n");
                            classWriter.append("{\n");
                            classWriter.append("@Inject\n");
                            classWriter.append("public ").append(stubFQN.getSimpleName()).append("_(").append(ApplicationContext.class.getSimpleName()).append(" applicationContext").append(")\n");
                            classWriter.append("{\n");
                            classWriter.append("super(applicationContext, \"").append(path).append("\");\n");
                            classWriter.append("}\n");
                            classWriter.append("}\n");
                            var17_20 = null;
                        }
                        catch (Throwable throwable) {
                            var17_20 = null;
                            classWriter.close();
                            throw throwable;
                        }
                        classWriter.close();
                        var19_21 = null;
                    }
                    catch (Throwable throwable) {
                        var19_21 = null;
                        Tools.safeClose(classWriter);
                        throw throwable;
                    }
                    Tools.safeClose(classWriter);
                    {
                        continue;
                        catch (IOException e) {
                            throw new CompilationException((Throwable)e, template.getFoo().getOrigin().get(this.processingEnv), ErrorCode.CANNOT_WRITE_QUALIFIED_TEMPLATE_CLASS, template.getFoo().getPath());
                        }
                    }
                }
                continue block12;
            }
        }
    }

    private void processController(String annotationName, Map<String, Object> annotationValues, Element annotatedElt) throws CompilationException {
        String id;
        ExecutableElement methodElt = (ExecutableElement)annotatedElt;
        TypeElement controllerElt = (TypeElement)methodElt.getEnclosingElement();
        FQN controllerFQN = new FQN(controllerElt.getQualifiedName().toString());
        ControllerModel controller = this.model.controllers.get(controllerFQN.getFullName());
        if (controller == null) {
            ElementHandle origin = ElementHandle.create(controllerElt);
            controller = new ControllerModel(origin, controllerFQN);
            this.model.controllers.put(controllerFQN.getFullName(), controller);
        }
        if ((id = (String)annotationValues.get("id")) == null) {
            id = "method_" + Math.abs(new Random().nextInt());
        }
        for (Phase phase : Phase.values()) {
            if (!phase.annotation.getSimpleName().equals(annotationName)) continue;
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (TypeMirror typeMirror : ((ExecutableType)methodElt.asType()).getParameterTypes()) {
                TypeMirror typeMirror2 = this.processingEnv.getTypeUtils().erasure(typeMirror);
                parameterTypes.add(((Object)typeMirror2).toString());
            }
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (VariableElement variableElement : methodElt.getParameters()) {
                parameterNames.add(variableElement.getSimpleName().toString());
            }
            for (MethodModel methodModel : controller.methods) {
                if (!methodModel.id.equals(id)) continue;
                throw new CompilationException(annotatedElt, ErrorCode.DUPLICATE_CONTROLLER_ID, id);
            }
            MethodModel methodModel = new MethodModel(controller, id, phase, methodElt.getSimpleName().toString(), parameterTypes, parameterNames);
            controller.methods.add(methodModel);
            break;
        }
    }

    private void processTemplate(String annotationName, Map<String, Object> annotationValues, Element annotatedElt) throws CompilationException {
        String path = (String)annotationValues.get("value");
        PackageElement packageElt = this.processingEnv.getElementUtils().getPackageOf(annotatedElt);
        Foo foo = new Foo(annotatedElt, packageElt.getQualifiedName().toString(), path);
        this.model.templates.add(foo);
    }

    private void processApplication(String annotationName, Map<String, Object> annotationValues, Element annotatedElt) throws CompilationException {
        String packageName;
        PackageElement packageElt = (PackageElement)annotatedElt;
        TypeMirror defaultControllerElt = (TypeMirror)annotationValues.get("defaultController");
        String defaultController = defaultControllerElt != null ? ((Object)defaultControllerElt).toString() : null;
        String name = (String)annotationValues.get("name");
        if (name == null) {
            String s = packageElt.getSimpleName().toString();
            name = Character.toUpperCase(s.charAt(0)) + s.substring(1) + "Application";
        }
        String templatesFQN = (packageName = packageElt.getQualifiedName().toString()).isEmpty() ? "templates" : packageName + ".templates";
        FQN fqn = new FQN(packageName, name);
        ApplicationModel application = new ApplicationModel(ElementHandle.create(packageElt), fqn, defaultController, templatesFQN);
        this.model.applications.put(packageName, application);
        Writer writer = null;
        try {
            try {
                JavaFileObject applicationFile = this.filer.createSourceFile(application.fqn.getFullName(), annotatedElt);
                writer = applicationFile.openWriter();
                writer.append("package ").append(application.fqn.getPackageName()).append(";\n");
                writer.append("import ").append(Tools.getImport(ApplicationDescriptor.class)).append(";\n");
                writer.append("public class ").append(application.fqn.getSimpleName()).append(" extends ").append(APPLICATION_DESCRIPTOR).append(" {\n");
                writer.append("public static final ").append(application.fqn.getSimpleName()).append(" DESCRIPTOR = new ").append(application.fqn.getSimpleName()).append("();\n");
                writer.append("private ").append(application.fqn.getSimpleName()).append("() {\n");
                writer.append("super(");
                writer.append(application.defaultController != null ? application.defaultController + ".class" : "null");
                writer.append(",");
                writer.append("\"").append(application.templatesFQN).append("\"");
                writer.append(");\n");
                writer.append("}\n");
                writer.append("}\n");
            }
            catch (IOException e) {
                throw new CompilationException(annotatedElt, ErrorCode.CANNOT_WRITE_APPLICATION_CLASS, new Object[0]);
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }
}

