/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.jar;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import org.juzu.impl.spi.fs.jar.JarFileSystem;
import org.juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPath {
    final JarFileSystem owner;
    final JarPath parent;
    final String entryName;
    final String name;
    final boolean dir;
    URL url;
    private JarEntry entry;
    private LinkedHashMap<String, JarPath> children;

    public JarPath(JarFileSystem owner) {
        this.entryName = "";
        this.name = "";
        this.dir = true;
        this.entry = null;
        this.children = null;
        this.parent = null;
        this.owner = owner;
    }

    public JarPath(JarFileSystem owner, JarPath parent, String entryName, String name, boolean dir) {
        this.parent = parent;
        this.entryName = entryName;
        this.name = name;
        this.dir = dir;
        this.children = null;
        this.owner = owner;
    }

    Iterator<JarPath> getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        return this.children.values().iterator();
    }

    JarPath getChild(String name) {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        return this.children.get(name);
    }

    URL getURL() throws IOException {
        if (this.url == null) {
            this.url = new URL("jar:" + this.owner.jarURL + "!/" + this.entryName);
        }
        return this.url;
    }

    void append(JarEntry entry) {
        JarPath existing;
        String name;
        String entryName = entry.getName();
        boolean dir = entryName.charAt(entryName.length() - 1) == '/';
        String path = entryName.substring(0, entryName.length() - (dir ? 1 : 0));
        Spliterator names = new Spliterator(path, '/');
        JarPath current = this;
        StringBuilder sb = new StringBuilder();
        while (true) {
            name = (String)names.next();
            sb.append(name);
            if (current.children == null) {
                current.children = new LinkedHashMap();
            }
            existing = current.children.get(name);
            if (!names.hasNext()) break;
            sb.append('/');
            if (existing == null) {
                existing = new JarPath(this.owner, current, sb.toString(), name, true);
                current.children.put(name, existing);
            }
            current = existing;
        }
        if (existing == null) {
            if (dir) {
                sb.append('/');
            }
            existing = new JarPath(this.owner, current, sb.toString(), name, dir);
            current.children.put(name, existing);
            existing.entry = entry;
        } else {
            if (dir != existing.dir) {
                throw new AssertionError();
            }
            if (existing.entry != null) {
                throw new AssertionError();
            }
            existing.entry = entry;
        }
    }
}

