/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.ram;

import java.util.LinkedHashMap;
import org.juzu.impl.spi.fs.ram.RAMFile;
import org.juzu.impl.spi.fs.ram.RAMPath;
import org.juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMDir
extends RAMPath {
    final LinkedHashMap<String, RAMPath> children = new LinkedHashMap();
    private long lastModified;

    public RAMDir() {
        this.lastModified = System.currentTimeMillis();
    }

    public RAMDir(RAMDir parent, String name) {
        super(parent, name);
    }

    @Override
    public RAMFile addFile(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Name must not container '/'");
        }
        if (this.children.containsKey(name)) {
            throw new IllegalStateException();
        }
        RAMFile dir = new RAMFile(this, name);
        this.children.put(name, dir);
        return dir;
    }

    @Override
    public RAMDir addDir(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Name must not container '/'");
        }
        if (this.children.containsKey(name)) {
            throw new IllegalStateException();
        }
        RAMDir dir = new RAMDir(this, name);
        this.children.put(name, dir);
        return dir;
    }

    @Override
    public void touch() {
        this.lastModified = System.currentTimeMillis();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public RAMPath getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public RAMFile update(Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content getContent() {
        return null;
    }

    @Override
    public Iterable<RAMPath> getChildren() {
        return this.children.values();
    }

    public void clear() {
        this.children.clear();
    }
}

