/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.fs.ram;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.juzu.impl.spi.fs.ram.RAMFile;
import org.juzu.impl.spi.fs.ram.RAMFileSystem;
import org.juzu.impl.spi.fs.ram.RAMPath;
import org.juzu.impl.spi.fs.ram.RAMURLConnection;
import org.juzu.impl.utils.Content;
import org.juzu.impl.utils.Spliterator;

class RAMURLStreamHandler
extends URLStreamHandler {
    private RAMFileSystem fs;

    public RAMURLStreamHandler(RAMFileSystem fs) {
        this.fs = fs;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        Content content;
        Iterable<String> names = Spliterator.split(u.getPath().substring(1), '/');
        RAMPath path = (RAMPath)this.fs.getPath(names);
        if (path instanceof RAMFile && (content = ((RAMFile)path).getContent()) != null) {
            return new RAMURLConnection(u, content);
        }
        throw new IOException("Could not connect to non existing content " + names);
    }
}

