/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;
import org.juzu.impl.inject.Export;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.cdi.CDIManager;
import org.juzu.impl.spi.inject.cdi.Container;
import org.juzu.impl.spi.inject.cdi.ContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private final CDIManager manager = CDIManager.boot.get();

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class type = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Export.class) && !this.manager.beans.contains(type)) {
            pat.veto();
        }
        for (Class current = type; current != null; current = current.getSuperclass()) {
            if (!this.manager.singletons.containsKey(current)) continue;
            pat.veto();
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        Container container = Container.boot.get();
        for (Scope scope : container.scopes) {
            event.addContext((Context)new ContextImpl(container.scopeController, scope, scope.getAnnotationType()));
        }
        event.addBean(this.bean(InjectManager.class, this.manager));
        for (Map.Entry entry : this.manager.singletons.entrySet()) {
            event.addBean(this.bean((Class)entry.getKey(), entry.getValue()));
        }
    }

    private Bean bean(final Class type, final Object instance) {
        return new Bean(){

            public Set<Type> getTypes() {
                HashSet<Type> types = new HashSet<Type>();
                types.add(type);
                types.add((Type)((Object)Object.class));
                return types;
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> qualifiers = new HashSet<Annotation>();
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
                return qualifiers;
            }

            public Class<? extends Annotation> getScope() {
                return Singleton.class;
            }

            public String getName() {
                return null;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Class<?> getBeanClass() {
                return type;
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public Object create(CreationalContext tCreationalContext) {
                return instance;
            }

            public void destroy(Object instance2, CreationalContext ctx) {
                ctx.release();
            }
        };
    }
}

