/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.inject.spring;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.juzu.impl.inject.ScopeController;
import org.juzu.impl.request.Scope;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.InjectManager;
import org.juzu.impl.spi.inject.spring.ScopeMetadataResolverImpl;
import org.juzu.impl.spi.inject.spring.SpringManager;
import org.juzu.impl.spi.inject.spring.SpringScope;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.CustomAutowireConfigurer;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBootstrap
extends InjectBootstrap {
    private ScopeMetadataResolverImpl resolver = new ScopeMetadataResolverImpl();
    private ClassLoader classLoader;
    private Map<String, BeanDefinition> beans = new LinkedHashMap<String, BeanDefinition>();
    private Map<String, Object> singletons = new LinkedHashMap<String, Object>();
    private Set<Scope> scopes = new LinkedHashSet<Scope>();
    private URL configurationURL;

    @Override
    public <T> InjectBootstrap declareBean(Class<T> type, Class<? extends T> implementationType) {
        AnnotatedGenericBeanDefinition definition;
        ScopeMetadata scopeMD;
        if (implementationType == null) {
            implementationType = type;
        }
        if ((scopeMD = this.resolver.resolveScopeMetadata((BeanDefinition)(definition = new AnnotatedGenericBeanDefinition(implementationType)))) != null) {
            definition.setScope(scopeMD.getScopeName());
        }
        String name = "" + Math.random();
        for (Annotation annotation : implementationType.getDeclaredAnnotations()) {
            if (!(annotation instanceof Named)) continue;
            Named named = (Named)annotation;
            name = named.value();
            break;
        }
        this.beans.put(name, (BeanDefinition)definition);
        return this;
    }

    public URL getConfigurationURL() {
        return this.configurationURL;
    }

    public void setConfigurationURL(URL configurationURL) {
        this.configurationURL = configurationURL;
    }

    @Override
    public <T> InjectBootstrap declareProvider(Class<T> type, Class<? extends Provider<T>> provider) {
        return this;
    }

    @Override
    public <T> InjectBootstrap bindSingleton(Class<T> type, T instance) {
        String name = "" + Math.random();
        this.singletons.put(name, instance);
        return this;
    }

    @Override
    public <P> InjectBootstrap addFileSystem(ReadFileSystem<P> fs) {
        return this;
    }

    @Override
    public InjectBootstrap addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public InjectBootstrap setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <B, I> InjectManager<B, I> create() throws Exception {
        Object factory = this.configurationURL != null ? new XmlBeanFactory((Resource)new UrlResource(this.configurationURL)) : new DefaultListableBeanFactory();
        factory.setBeanClassLoader(this.classLoader);
        for (Scope scope : this.scopes) {
            factory.registerScope(scope.name().toLowerCase(), (org.springframework.beans.factory.config.Scope)new SpringScope(scope, ScopeController.INSTANCE));
        }
        for (Map.Entry entry : this.singletons.entrySet()) {
            factory.registerSingleton((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.beans.entrySet()) {
            factory.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)entry.getValue());
        }
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setAutowiredAnnotationType(Inject.class);
        beanPostProcessor.setBeanFactory((BeanFactory)factory);
        factory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
        HashSet<Class<Named>> hashSet = new HashSet<Class<Named>>();
        hashSet.add(Named.class);
        CustomAutowireConfigurer configurer = new CustomAutowireConfigurer();
        configurer.setCustomQualifierTypes(hashSet);
        QualifierAnnotationAutowireCandidateResolver customResolver = new QualifierAnnotationAutowireCandidateResolver();
        factory.setAutowireCandidateResolver((AutowireCandidateResolver)customResolver);
        configurer.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
        return new SpringManager((DefaultListableBeanFactory)factory, this.classLoader);
    }
}

