/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.request.portlet;

import java.io.IOException;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.juzu.Phase;
import org.juzu.URLBuilder;
import org.juzu.impl.spi.request.MimeBridge;
import org.juzu.impl.spi.request.portlet.PortletRequestBridge;
import org.juzu.impl.spi.request.portlet.URLBuilderImpl;
import org.juzu.metadata.ControllerMethod;
import org.juzu.text.Printer;
import org.juzu.text.WriterPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    private final Printer printer;

    PortletMimeBridge(Rq request, Rs response) throws IOException {
        super(request, response);
        this.printer = new WriterPrinter(response.getWriter());
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    @Override
    public URLBuilder createURLBuilder(ControllerMethod method) {
        PortletURL url;
        Phase phase = method.getPhase();
        switch (phase) {
            case ACTION: {
                url = ((MimeResponse)this.response).createActionURL();
                break;
            }
            case RENDER: {
                url = ((MimeResponse)this.response).createRenderURL();
                break;
            }
            case RESOURCE: {
                url = ((MimeResponse)this.response).createResourceURL();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected phase " + (Object)((Object)phase)));
            }
        }
        url.setParameter("op", method.getId());
        return new URLBuilderImpl((BaseURL)url);
    }
}

