/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.spi.template.gtmpl;

import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.juzu.template.TemplateRenderContext;
import org.juzu.text.CharArray;

public class GroovyPrinter
extends GroovyObjectSupport
implements GroovyInterceptable {
    final TemplateRenderContext renderContext;

    public GroovyPrinter(TemplateRenderContext renderContext) throws NullPointerException {
        if (renderContext == null) {
            throw new NullPointerException("No null render context accepted");
        }
        this.renderContext = renderContext;
    }

    public Object invokeMethod(String name, Object args) {
        Object[] array;
        if (args instanceof Object[] && (array = (Object[])args).length == 1) {
            if ("print".equals(name)) {
                this.print(array[0]);
                return null;
            }
            if ("println".equals(name)) {
                this.println(array[0]);
                return null;
            }
        }
        return super.invokeMethod(name, args);
    }

    public final void println(Object o) {
        this.print(o);
        this.println();
    }

    public final void println() {
        try {
            this.renderContext.getPrinter().write('\n');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Object format(Object o) {
        Locale locale;
        if (o instanceof Date && (locale = this.renderContext.getLocale()) != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
            o = dateFormat.format((Date)o);
        }
        return o;
    }

    private String toString(Object o) {
        Object f = this.format(o);
        if (f == null) {
            return "null";
        }
        if (f instanceof String) {
            return (String)f;
        }
        return o.toString();
    }

    public final void print(Object o) {
        try {
            if (o instanceof CharArray) {
                this.renderContext.getPrinter().write((CharArray)o);
            } else if (o instanceof GString) {
                GString gs = (GString)o;
                Object[] values = gs.getValues();
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.format(values[i]);
                }
                this.renderContext.getPrinter().write(o.toString());
            } else {
                this.renderContext.getPrinter().write(this.toString(o));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

