/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.impl.utils;

import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevClassLoader
extends ClassLoader {
    public DevClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String classPath;
        URL url;
        Class<?> found = super.loadClass(name, resolve);
        if (found.getClassLoader() == super.getParent() && (url = this.getResource(classPath = name.replace('.', '/') + ".class")) == null) {
            throw new ClassNotFoundException();
        }
        return found;
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null && this.shouldLoad(url, name)) {
            return url;
        }
        return null;
    }

    private boolean shouldLoad(URL url, String name) {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            String path = url.getPath();
            return !path.endsWith("/WEB-INF/classes/" + name);
        }
        if ("jar".equals(protocol)) {
            int index;
            String path = url.getPath();
            String nested = path.substring(0, index = path.indexOf("!/"));
            if (nested.endsWith(".jar")) {
                return true;
            }
            throw new UnsupportedOperationException("handle me gracefully " + url);
        }
        throw new UnsupportedOperationException("handle me gracefully " + url);
    }
}

