/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import org.juzu.impl.application.ApplicationBootstrap;
import org.juzu.impl.application.InternalApplicationContext;
import org.juzu.impl.compiler.CompilationError;
import org.juzu.impl.compiler.Compiler;
import org.juzu.impl.fs.Change;
import org.juzu.impl.fs.FileSystemScanner;
import org.juzu.impl.processor.MainProcessor;
import org.juzu.impl.spi.fs.ReadFileSystem;
import org.juzu.impl.spi.fs.jar.JarFileSystem;
import org.juzu.impl.spi.fs.ram.RAMFileSystem;
import org.juzu.impl.spi.fs.ram.RAMPath;
import org.juzu.impl.spi.fs.war.WarFileSystem;
import org.juzu.impl.spi.inject.InjectBootstrap;
import org.juzu.impl.spi.inject.cdi.CDIBootstrap;
import org.juzu.impl.spi.inject.spring.SpringBootstrap;
import org.juzu.impl.spi.request.portlet.PortletActionBridge;
import org.juzu.impl.spi.request.portlet.PortletRenderBridge;
import org.juzu.impl.spi.request.portlet.PortletResourceBridge;
import org.juzu.impl.utils.DevClassLoader;
import org.juzu.metadata.ApplicationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuzuPortlet
implements Portlet,
ResourceServingPortlet {
    private InternalApplicationContext applicationContext;
    private boolean prod;
    private PortletConfig config;
    private FileSystemScanner<String> devScanner;
    private List<URL> jarURLs;
    private String applicationName;

    public void init(PortletConfig config) throws PortletException {
        try {
            String runMode = config.getInitParameter("juzu.run_mode");
            runMode = runMode == null ? "prod" : runMode.trim().toLowerCase();
            ArrayList<URL> jars = new ArrayList<URL>();
            WarFileSystem bah = WarFileSystem.create(config.getPortletContext(), "/WEB-INF/lib/");
            Iterator<String> i = bah.getChildren(bah.getRoot());
            while (i.hasNext()) {
                String s = i.next();
                URL url = bah.getURL(s);
                jars.add(url);
            }
            this.config = config;
            this.prod = !"dev".equals(runMode);
            this.jarURLs = jars;
            Collection<CompilationError> errors = this.boot();
            if (errors != null && errors.size() > 0) {
                System.out.println("Error when compiling application " + errors);
            }
        }
        catch (IOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private Collection<CompilationError> boot() throws PortletException {
        if (this.prod) {
            if (this.applicationContext == null) {
                try {
                    WarFileSystem fs = WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/classes/");
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    this.boot(fs, cl);
                }
                catch (Exception e) {
                    throw new PortletException("Could not find an application to start", (Throwable)e);
                }
            }
            return null;
        }
        try {
            if (this.devScanner != null) {
                Map<String, Change> changes = this.devScanner.scan();
                if (changes.size() > 0) {
                    System.out.println("Detected changes : " + changes);
                    this.applicationContext = null;
                } else {
                    System.out.println("No changes detected");
                }
            }
            if (this.applicationContext == null) {
                System.out.println("Building application");
                ArrayList<URL> classPath = new ArrayList<URL>();
                for (URL jarURL : this.jarURLs) {
                    URL configURL = new URL("jar:" + jarURL.toString() + "!/org/juzu/config.properties");
                    try {
                        configURL.openStream();
                    }
                    catch (IOException e) {
                        classPath.add(jarURL);
                    }
                }
                WarFileSystem fs = WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/src/");
                RAMFileSystem classes = new RAMFileSystem();
                Compiler<String, RAMPath> compiler = new Compiler<String, RAMPath>(classPath, fs, classes);
                compiler.addAnnotationProcessor(new MainProcessor());
                List<CompilationError> res = compiler.compile();
                if (res.isEmpty()) {
                    DevClassLoader cl1 = new DevClassLoader(Thread.currentThread().getContextClassLoader());
                    URLClassLoader cl2 = new URLClassLoader(new URL[]{classes.getURL()}, (ClassLoader)cl1);
                    this.boot(classes, cl2);
                    this.devScanner = new FileSystemScanner<String>(fs);
                    this.devScanner.scan();
                    System.out.println("[" + this.applicationName + "] Dev mode scanner monitoring " + fs.getFile(fs.getRoot()));
                    return Collections.emptyList();
                }
                return res;
            }
            return null;
        }
        catch (Exception e) {
            throw e instanceof PortletException ? (PortletException)e : new PortletException((Throwable)e);
        }
    }

    private <P, D> void boot(ReadFileSystem<P> classes, ClassLoader cl) throws Exception {
        URL configurationURL;
        InjectBootstrap injectBootstrap;
        P f = classes.getFile(Arrays.asList("org", "juzu"), "config.properties");
        URL url = classes.getURL(f);
        InputStream in = url.openStream();
        Properties props = new Properties();
        props.load(in);
        String appName = this.config.getInitParameter("juzu.app_name");
        String fqn = null;
        if (appName != null) {
            fqn = props.getProperty(appName.trim());
        } else {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String a = entry.getKey().toString();
                String b = entry.getValue().toString();
                if (a.length() <= 0 || b.length() <= 0) continue;
                fqn = b;
                break;
            }
        }
        if (fqn == null) {
            throw new Exception("Could not find an application to start " + props);
        }
        Class<?> clazz = cl.loadClass(fqn);
        Field field = clazz.getDeclaredField("DESCRIPTOR");
        ApplicationDescriptor descriptor = (ApplicationDescriptor)field.get(null);
        this.applicationName = descriptor.getName();
        URL mainURL = null;
        for (URL jarURL : this.jarURLs) {
            URL configURL = new URL("jar:" + jarURL.toString() + "!/org/juzu/impl/application/ApplicationBootstrap.class");
            try {
                configURL.openStream();
                mainURL = jarURL;
                break;
            }
            catch (IOException ignore) {
            }
        }
        if (mainURL == null) {
            throw new PortletException("Cannot find juzu jar among " + this.jarURLs);
        }
        JarFileSystem libs = new JarFileSystem(new JarFile(new File(mainURL.toURI())));
        String inject = this.config.getInitParameter("juzu.inject");
        if (inject == null) {
            inject = "weld";
        }
        if ("weld".equals(inject = inject.trim().toLowerCase())) {
            injectBootstrap = new CDIBootstrap();
        } else if ("spring".equals(inject)) {
            injectBootstrap = new SpringBootstrap();
        } else {
            throw new PortletException("unrecognized inject vendor " + inject);
        }
        System.out.println("[" + this.applicationName + "] Using injection " + injectBootstrap.getClass().getName());
        injectBootstrap.addFileSystem(classes);
        injectBootstrap.addFileSystem(libs);
        injectBootstrap.setClassLoader(cl);
        if (injectBootstrap instanceof SpringBootstrap && (configurationURL = this.config.getPortletContext().getResource("/WEB-INF/spring.xml")) != null) {
            ((SpringBootstrap)injectBootstrap).setConfigurationURL(configurationURL);
        }
        ApplicationBootstrap bootstrap = new ApplicationBootstrap(injectBootstrap, descriptor);
        System.out.println("[" + this.applicationName + "] Starting");
        bootstrap.start();
        this.applicationContext = bootstrap.getContext();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.applicationContext.invoke(new PortletActionBridge(request, response));
    }

    private void purgeSession(PortletRequest req) {
        PortletSession session = req.getPortletSession();
        for (String key : new HashSet(session.getAttributeMap().keySet())) {
            session.removeAttribute(key);
        }
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Collection<CompilationError> errors = this.boot();
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                this.purgeSession((PortletRequest)request);
            }
            this.applicationContext.invoke(new PortletRenderBridge(request, response));
            PortletSession session = request.getPortletSession(false);
            if (session != null) {
                session.removeAttribute("org.juzu.flash_scope");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (CompilationError error : errors) {
                String at = error.getSource();
                sb.append("<p>");
                sb.append("<div>Compilation error at ").append(at).append(" ").append(error.getLocation()).append("</div>");
                sb.append("<div>");
                sb.append(error.getMessage());
                sb.append("</div>");
                sb.append("</p>");
            }
            response.getWriter().print(sb);
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        Collection<CompilationError> errors = this.boot();
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                this.purgeSession((PortletRequest)request);
            }
            this.applicationContext.invoke(new PortletResourceBridge(request, response));
        } else {
            StringBuilder sb = new StringBuilder();
            for (CompilationError error : errors) {
                String at = error.getSource();
                sb.append("<p>");
                sb.append("<div>Compilation error at ").append(at).append(" ").append(error.getLocation()).append("</div>");
                sb.append("<div>");
                sb.append(error.getMessage());
                sb.append("</div>");
                sb.append("</p>");
            }
            response.getWriter().print(sb);
        }
    }

    public void destroy() {
    }
}

