/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.controller.descriptor;

import juzu.impl.utils.Cardinality;
import juzu.impl.utils.ParameterMap;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerParameter {
    private final String name;
    private final Cardinality cardinality;
    private final String value;
    private final Class<?> type;

    public ControllerParameter(String name, Cardinality cardinality) throws NullPointerException {
        this(name, cardinality, null);
    }

    public ControllerParameter(String name, Cardinality cardinality, String value) throws NullPointerException {
        this(name, cardinality, value, null);
    }

    public ControllerParameter(String name, Cardinality cardinality, String value, Class<?> type) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null parameter name accepted");
        }
        if (cardinality == null) {
            throw new NullPointerException("No null parameter cardinality accepted");
        }
        this.name = name;
        this.cardinality = cardinality;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public String getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    void setValue(ParameterMap builder, Object value) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ControllerParameter) {
            ControllerParameter that = (ControllerParameter)obj;
            return this.name.equals(that.name) && Tools.safeEquals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return "ControllerParameter[name=" + this.name + ",value=" + this.value + "]";
    }
}

