/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.lang.model.element.Element;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaModel
extends MetaModelObject {
    public static final Logger log = BaseProcessor.getLogger(MetaModel.class);
    public ProcessingContext env;
    private final EventQueue queue = new EventQueue();
    private final EventQueue dispatch = new EventQueue();
    private static final ThreadLocal<MetaModel> current = new ThreadLocal();
    final LinkedHashMap<String, MetaModelPlugin> plugins = new LinkedHashMap();
    private Set<Class> supportedAnnotations;
    private boolean queuing = false;

    public Set<Class> getSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ProcessingContext env) {
        this.env = env;
        try {
            LinkedHashMap<String, MetaModelPlugin> plugins = new LinkedHashMap<String, MetaModelPlugin>();
            StringBuilder msg = new StringBuilder("Using plugins:");
            for (MetaModelPlugin plugin : env.loadServices(MetaModelPlugin.class)) {
                msg.append(" ").append(plugin.getName());
                plugins.put(plugin.getName(), plugin);
            }
            log.log(msg);
            for (MetaModelPlugin plugin : plugins.values()) {
                plugin.init(this);
            }
            HashSet<Class> supportedAnnotations = new HashSet<Class>();
            for (MetaModelPlugin plugin : plugins.values()) {
                Set<Class<? extends Annotation>> processed = plugin.getAnnotationTypes();
                log.log("Plugin " + plugin.getName() + " wants to process " + processed);
                supportedAnnotations.addAll(processed);
            }
            this.plugins.putAll(plugins);
            this.supportedAnnotations = supportedAnnotations;
        }
        finally {
            this.env = null;
        }
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        for (MetaModelPlugin plugin : this.plugins.values()) {
            JSON pluginJSON = plugin.toJSON(this);
            if (pluginJSON == null) continue;
            json.set(plugin.getName(), pluginJSON);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postActivate(ProcessingContext env) {
        this.env = env;
        current.set(this);
        this.queuing = true;
        try {
            this.garbage(this, this, new HashSet<MetaModelObject>());
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.postActivate(this);
            }
        }
        finally {
            this.queuing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnnotation(Element element, String annotationType, AnnotationData annotationData) throws CompilationException {
        this.queuing = true;
        try {
            log.log("Processing annotation " + element);
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.processAnnotation(this, element, annotationType, annotationData);
            }
        }
        finally {
            this.queuing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessAnnotations() throws CompilationException {
        this.queuing = true;
        try {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.postProcessAnnotations(this);
            }
        }
        finally {
            this.queuing = false;
        }
        for (MetaModelPlugin plugin : this.plugins.values()) {
            plugin.processEvents(this, new EventQueue(this.dispatch));
        }
        this.dispatch.clear();
        log.log("Post processing");
        for (MetaModelPlugin plugin : this.plugins.values()) {
            plugin.postProcessEvents(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePassivate() {
        try {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.prePassivate(this);
            }
        }
        finally {
            this.env = null;
            current.set(null);
        }
    }

    private void garbage(MetaModel model, MetaModelObject object, HashSet<MetaModelObject> visited) {
        if (!visited.contains(object)) {
            visited.add(this);
            for (MetaModelObject child : object.getChildren()) {
                this.garbage(model, child, visited);
            }
            if (!object.exist(model)) {
                object.remove();
            }
        }
    }

    @Override
    public void queue(MetaModelEvent event) {
        if (!this.queuing) {
            throw new IllegalStateException("Not queueing");
        }
        this.queue.queue(event);
        this.dispatch.queue(event);
    }

    public EventQueue getQueue() {
        return this.queue;
    }
}

