/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelObject;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class MetaModelTestCase
extends AbstractTestCase {
    private static final Key<MetaModelObject> A = Key.of((Object)"a", MetaModelObject.class);
    private static final Key<MetaModelObject> B = Key.of((Object)"b", MetaModelObject.class);
    private static final Key<MetaModelObject> C = Key.of((Object)"c", MetaModelObject.class);
    private static final Key<MetaModelObject> D = Key.of((Object)"d", MetaModelObject.class);

    @Test
    public void testCannotRemoveRoot() {
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        a.addChild(B, b);
        a.remove();
        MetaModelTestCase.assertSame((Object)((Object)b), (Object)a.getChild(B));
        MetaModelTestCase.assertEquals((int)0, (int)a.removed);
        MetaModelTestCase.assertEquals((int)0, (int)b.removed);
    }

    @Test
    public void testTransitiveRemove() {
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        Simple c = new Simple("c");
        a.addChild(B, b).addChild(C, (MetaModelObject)c);
        b.remove();
        MetaModelTestCase.assertEquals((int)0, (int)a.removed);
        MetaModelTestCase.assertEquals((int)1, (int)b.removed);
        MetaModelTestCase.assertEquals((int)1, (int)c.removed);
    }

    @Test
    public void testTransitiveRemoveChild() {
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        Simple c = new Simple("c");
        a.addChild(B, b).addChild(C, (MetaModelObject)c);
        a.removeChild(B);
        MetaModelTestCase.assertEquals((int)0, (int)a.removed);
        MetaModelTestCase.assertEquals((int)1, (int)b.removed);
        MetaModelTestCase.assertEquals((int)1, (int)c.removed);
    }

    @Test
    public void testRemoveOrphan() {
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        Simple c = new Simple("c");
        a.addChild(C, c);
        b.addChild(C, c);
        a.removeChild(C);
        MetaModelTestCase.assertEquals((int)0, (int)c.removed);
        b.removeChild(C);
        MetaModelTestCase.assertEquals((int)1, (int)c.removed);
    }

    @Test
    public void testTransitiveGarbage() {
        MetaModel m = new MetaModel();
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        m.addChild(A, (MetaModelObject)a).addChild(B, (MetaModelObject)b);
        b.exist = false;
        a.exist = false;
        m.postActivate((ProcessingContext)null);
        MetaModelTestCase.assertNull((Object)a.getChild(B));
        MetaModelTestCase.assertNull((Object)m.getChild(B));
        MetaModelTestCase.assertEquals((int)1, (int)a.removed);
        MetaModelTestCase.assertEquals((int)1, (int)b.removed);
    }

    @Test
    public void testForcedGarbage() {
        MetaModel m = new MetaModel();
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        m.addChild(A, (MetaModelObject)a).addChild(B, (MetaModelObject)b);
        a.exist = false;
        m.postActivate((ProcessingContext)null);
        MetaModelTestCase.assertNull((Object)a.getChild(B));
        MetaModelTestCase.assertNull((Object)m.getChild(A));
        MetaModelTestCase.assertEquals((int)1, (int)a.removed);
        MetaModelTestCase.assertEquals((int)1, (int)b.removed);
    }

    @Test
    public void testForcedGarbage2() {
        MetaModel m = new MetaModel();
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        Simple c = new Simple("c");
        m.addChild(A, (MetaModelObject)a).addChild(B, (MetaModelObject)b);
        m.addChild(C, (MetaModelObject)c).addChild(B, (MetaModelObject)b);
        a.exist = false;
        m.postActivate((ProcessingContext)null);
        MetaModelTestCase.assertNull((Object)a.getChild(B));
        MetaModelTestCase.assertNull((Object)m.getChild(A));
        MetaModelTestCase.assertSame((Object)((Object)b), (Object)c.getChild(B));
        MetaModelTestCase.assertEquals((int)1, (int)a.removed);
        MetaModelTestCase.assertEquals((int)0, (int)b.removed);
        MetaModelTestCase.assertEquals((int)0, (int)c.removed);
        c.exist = false;
        m.postActivate((ProcessingContext)null);
        MetaModelTestCase.assertEquals((int)1, (int)a.removed);
        MetaModelTestCase.assertEquals((int)1, (int)b.removed);
        MetaModelTestCase.assertEquals((int)1, (int)c.removed);
    }

    @Test
    public void testBug() {
        Simple a = new Simple("a");
        Simple b = new Simple("b");
        Simple c = new Simple("c");
        Simple d = new Simple("d");
        a.addChild(C, c);
        b.addChild(C, c);
        c.addChild(D, d);
        MetaModelTestCase.assertSame((Object)((Object)c), (Object)a.removeChild(C));
        MetaModelTestCase.assertNull((Object)a.getChild(C));
        MetaModelTestCase.assertSame((Object)((Object)c), (Object)b.getChild(C));
        MetaModelTestCase.assertSame((Object)((Object)d), (Object)c.getChild(D));
    }

    static class Simple
    extends MetaModelObject {
        final String name;
        boolean exist = true;
        int removed = 0;

        Simple(String name) {
            this.name = name;
        }

        public boolean exist(MetaModel model) {
            return this.exist;
        }

        protected void preRemove() {
            ++this.removed;
        }

        public String toString() {
            return "Simple[" + this.name + "]";
        }
    }
}

