/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.URLBuilder;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.request.Request;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockHttpContext;
import juzu.test.protocol.mock.MockSecurityContext;
import juzu.test.protocol.mock.MockWindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockRequestBridge
implements RequestBridge {
    protected final MockClient client;
    private final String methodId;
    private final Map<String, String[]> parameters;
    private final ScopedContext attributes;
    private final MockHttpContext httpContext;
    private final MockSecurityContext securityContext;
    private final MockWindowContext windowContext;
    private final List<Scoped> attributesHistory;

    public MockRequestBridge(MockClient client, String methodId, Map<String, String[]> parameters) {
        this.client = client;
        this.methodId = methodId;
        this.parameters = parameters;
        this.attributes = new ScopedContext();
        this.httpContext = new MockHttpContext();
        this.securityContext = new MockSecurityContext();
        this.windowContext = new MockWindowContext();
        this.attributesHistory = new ArrayList<Scoped>();
    }

    public List<Scoped> getAttributesHistory() {
        return this.attributesHistory;
    }

    public <T> T getProperty(PropertyType<T> propertyType) {
        if (RequestContext.METHOD_ID.equals(propertyType)) {
            return propertyType.getType().cast(this.methodId);
        }
        return null;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public Scoped getFlashValue(Object key) {
        return this.client.getFlashValue(key);
    }

    public void setFlashValue(Object key, Scoped value) {
        this.client.setFlashValue(key, value);
    }

    public Scoped getRequestValue(Object key) {
        return this.attributes.get(key);
    }

    public void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            this.attributes.set(key, value);
        } else {
            this.attributes.set(key, null);
        }
    }

    public Scoped getSessionValue(Object key) {
        return this.client.getSession().get(key);
    }

    public void setSessionValue(Object key, Scoped value) {
        if (value != null) {
            this.client.getSession().set(key, value);
        } else {
            this.client.getSession().set(key, null);
        }
    }

    public Scoped getIdentityValue(Object key) {
        return null;
    }

    public void setIdentityValue(Object key, Scoped value) {
    }

    public MockSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public MockHttpContext getHttpContext() {
        return this.httpContext;
    }

    public MockWindowContext getWindowContext() {
        return this.windowContext;
    }

    void close() {
        this.attributesHistory.addAll(Tools.list((Iterable)this.attributes));
        this.attributes.close();
    }

    public <T> String checkPropertyValidity(Phase phase, PropertyType<T> propertyType, T propertyValue) {
        return this._checkPropertyValidity(phase, propertyType, propertyValue);
    }

    public String _checkPropertyValidity(Phase phase, PropertyType<?> propertyType, Object propertyValue) {
        if (propertyType == URLBuilder.ESCAPE_XML) {
            return null;
        }
        if (propertyType == RequestContext.METHOD_ID) {
            return null;
        }
        return "Unsupported property " + propertyType + " = " + propertyValue;
    }

    public String renderURL(Phase phase, Map<String, String[]> parameters, PropertyMap properties) {
        JSON props = new JSON();
        if (properties != null) {
            for (PropertyType property : properties) {
                Object value;
                String valid = this._checkPropertyValidity(phase, property, value = properties.getValue(property));
                if (valid != null) {
                    throw new IllegalArgumentException(valid);
                }
                props.set(property.getClass().getName(), value);
            }
        }
        JSON url = new JSON();
        url.set("phase", (Object)phase.name());
        url.map("parameters", parameters);
        url.set("properties", (Object)props);
        return url.toString();
    }

    public void begin(Request request) {
    }
}

