/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.asset.Asset;
import juzu.impl.utils.ParameterHashMap;
import juzu.impl.utils.ParameterMap;
import juzu.impl.utils.Tools;
import juzu.io.Stream;
import juzu.io.Streamable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    protected final PropertyMap properties;

    protected Response() {
        this.properties = new PropertyMap();
    }

    protected Response(PropertyMap properties) {
        this.properties = properties;
    }

    public <T> Response with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
        if (propertyType == null) {
            throw new NullPointerException("No null property type allowed");
        }
        this.properties.setValue(propertyType, propertyValue);
        return this;
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static Render render(CharSequence content) {
        return Response.render(null, content);
    }

    public static Render render(String title, CharSequence content) {
        return new Render(new Streamable.CharSequence(content)).withTitle(title);
    }

    public static Content<Stream.Char> ok(CharSequence content) {
        return Response.content(200, content);
    }

    public static Content<Stream.Binary> ok(String mimeType, InputStream content) {
        return Response.content(200, mimeType, content);
    }

    public static Content<Stream.Binary> ok(InputStream content) {
        return Response.ok(null, content);
    }

    public static Content<Stream.Char> notFound(CharSequence content) {
        return Response.content(404, content);
    }

    public static Content<Stream.Char> content(int code, CharSequence content) {
        return Response.content(code, new Streamable.CharSequence(content));
    }

    public static Content<Stream.Char> content(int code, Streamable<Stream.Char> content) {
        return new Content<Stream.Char>(code, Stream.Char.class, content).withMimeType("text/html");
    }

    public static Content<Stream.Binary> content(int code, InputStream content) {
        return Response.content(code, null, content);
    }

    public static Content<Stream.Binary> content(int code, String mimeType, InputStream content) {
        return new Content<Stream.Binary>(code, Stream.Binary.class, new Streamable.InputStream(content)).withMimeType(mimeType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Render
    extends Content<Stream.Char> {
        public static SCRIPT SCRIPT = new SCRIPT();
        public static STYLESHEET STYLESHEET = new STYLESHEET();
        public static TITLE TITLE = new TITLE();

        @Override
        public <T> Render with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Render)super.with((PropertyType)propertyType, (Object)propertyValue);
        }

        public Render() {
            super(200, Stream.Char.class);
        }

        public Render(PropertyMap properties, Streamable<Stream.Char> streamable) {
            super(200, Stream.Char.class, properties, streamable);
        }

        public Render(Streamable<Stream.Char> streamable) {
            super(200, Stream.Char.class, streamable);
        }

        public String getTitle() {
            return this.properties.getValue(TITLE);
        }

        public Render withTitle(String title) {
            this.properties.setValue(TITLE, title);
            return this;
        }

        public Iterable<Asset> getScripts() {
            Iterable<Asset> scripts = this.properties.getValues(SCRIPT);
            return scripts != null ? scripts : Tools.emptyIterable();
        }

        public Render addScript(Asset script) throws NullPointerException {
            if (script == null) {
                throw new NullPointerException("No null script accepted");
            }
            this.properties.addValue(SCRIPT, script);
            return this;
        }

        public Iterable<Asset> getStylesheets() {
            Iterable<Asset> stylesheets = this.properties.getValues(STYLESHEET);
            return stylesheets != null ? stylesheets : Tools.emptyIterable();
        }

        public Render addStylesheet(Asset stylesheet) throws NullPointerException {
            if (stylesheet == null) {
                throw new NullPointerException("No null stylesheet accepted");
            }
            this.properties.addValue(SCRIPT, stylesheet);
            return this;
        }

        public String toString() {
            return "Response.Render[]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TITLE
        extends PropertyType<String> {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class STYLESHEET
        extends PropertyType<Asset> {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SCRIPT
        extends PropertyType<Asset> {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content<S extends Stream>
    extends Response {
        public static MIME_TYPE MIME_TYPE = new MIME_TYPE();
        private int status;
        private final Class<S> kind;
        private Streamable<S> streamable;

        protected Content(int status, Class<S> kind) {
            this.status = status;
            this.kind = kind;
            this.streamable = null;
        }

        protected Content(int status, Class<S> kind, PropertyMap properties) {
            super(properties);
            this.status = status;
            this.kind = kind;
            this.streamable = null;
        }

        protected Content(int status, Class<S> kind, Streamable<S> streamable) {
            this.status = status;
            this.kind = kind;
            this.streamable = streamable;
        }

        protected Content(int status, Class<S> kind, PropertyMap properties, Streamable<S> streamable) {
            super(properties);
            this.status = status;
            this.kind = kind;
            this.streamable = streamable;
        }

        public Class<S> getKind() {
            return this.kind;
        }

        public Streamable<S> getStreamable() {
            return this.streamable;
        }

        public String getMimeType() {
            return this.properties.getValue(MIME_TYPE);
        }

        public Content<S> withMimeType(String mimeType) {
            this.properties.setValue(MIME_TYPE, mimeType);
            return this;
        }

        public Integer getStatus() {
            return this.status;
        }

        @Override
        public <T> Content with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Content)super.with(propertyType, propertyValue);
        }

        public void send(S stream) throws IOException {
            this.streamable.send(stream);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MIME_TYPE
        extends PropertyType<String> {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Redirect
    extends Response {
        private final String location;

        public Redirect(String location) {
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        @Override
        public <T> Redirect with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Redirect)super.with(propertyType, propertyValue);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Redirect) {
                Redirect that = (Redirect)obj;
                return this.location.equals(that.location);
            }
            return false;
        }

        public String toString() {
            return "Response.Redirect[location" + this.location + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Update
    extends Response {
        private ParameterMap parameterMap = new ParameterHashMap();

        public Update setParameter(String name, String value) throws NullPointerException {
            this.parameterMap.setParameter(name, value);
            return this;
        }

        public Update setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
            this.parameterMap.setParameter(name, value);
            return this;
        }

        public Update setParameters(Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
            this.parameterMap.setParameters(parameters);
            return this;
        }

        public Map<String, String[]> getParameters() {
            return this.parameterMap;
        }

        @Override
        public <T> Update with(PropertyType<T> propertyType, T propertyValue) throws NullPointerException {
            return (Update)super.with(propertyType, propertyValue);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Update) {
                Update that = (Update)obj;
                return ((Object)this.parameterMap).equals(that.parameterMap) && this.properties.equals(that.properties);
            }
            return false;
        }

        public String toString() {
            return "Response.Update[parameters" + this.parameterMap + ",properties=" + this.properties + "]";
        }
    }
}

