/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.util.Arrays;
import junit.framework.Assert;
import juzu.impl.utils.Path;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class PathTestCase {
    @Test
    public void testParseIAE() {
        this.assertIAE(".");
        this.assertIAE(".a");
        this.assertIAE("a.");
        this.assertIAE("ab.");
        this.assertIAE("a.b.c");
        this.assertIAE("/.a");
        this.assertIAE("a/.b");
        this.assertIAE("a/b.");
        this.assertIAE("a/bc.");
        this.assertIAE("..");
    }

    @Test
    public void testParseName() {
        this.assertPath(false, new String[0], "", null, "");
        this.assertPath(true, new String[0], "", null, "/");
        this.assertPath(true, new String[0], "", null, "//");
        this.assertPath(false, new String[0], "a", null, "a");
        this.assertPath(true, new String[0], "a", null, "/a");
        this.assertPath(true, new String[0], "a", null, "//a");
        this.assertPath(false, new String[]{"a"}, "", null, "a/");
        this.assertPath(false, new String[0], "a", "b", "a.b");
        this.assertPath(true, new String[0], "a", "b", "/a.b");
        this.assertPath(false, new String[]{"a"}, "b", null, "a/b");
        this.assertPath(false, new String[]{"a"}, "b", null, "a//b");
        this.assertPath(false, new String[]{"a"}, "b", "c", "a/b.c");
        this.assertPath(true, new String[]{"a"}, "b", "c", "/a/b.c");
    }

    @Test
    public void testAppend() {
        this.assertIAE("a", "b./c");
        this.assertIAE("a", ".b/c");
        this.assertIAE("a", "..b/c");
        this.assertIAE("a", ".b./c");
        this.assertIAE("a", "b../c");
        this.assertIAE("a", "bb./c");
        this.assertIAE("a", "b.b/c");
        this.assertIAE("a", ".bb/c");
        this.assertIAE("a", ".../c");
    }

    @Test
    public void testAppendIAE() {
        this.assertPath(false, new String[0], "b", null, Path.parse((String)"").append("b"));
        this.assertPath(false, new String[0], "b", "c", Path.parse((String)"").append("b.c"));
        this.assertPath(false, new String[0], "b", null, Path.parse((String)"").append("./b"));
        this.assertPath(false, new String[0], "c", null, Path.parse((String)"a/b").append("../c"));
        this.assertPath(false, new String[0], "b", null, Path.parse((String)"").append("a/../b"));
        this.assertPath(false, new String[0], "b", "c", Path.parse((String)"").append("b.c"));
        this.assertPath(false, new String[]{"a"}, "c", null, Path.parse((String)"a/b").append("c"));
        this.assertPath(false, new String[]{"a"}, "d", null, Path.parse((String)"a/b.c").append("d"));
    }

    private void assertIAE(String path) {
        try {
            Path.parse((String)path);
            throw AbstractTestCase.failure("Was expecting parsing of " + path + " to throw an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    private void assertIAE(String prefixPath, String path) {
        Path p = Path.parse((String)prefixPath);
        try {
            p.append(path);
            throw AbstractTestCase.failure("Was expecting parsing of " + path + " to throw an IAE");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    private void assertPath(boolean absolute, String[] names, String name, String extension, Path test) {
        Assert.assertEquals((boolean)absolute, (boolean)test.isAbsolute());
        Assert.assertEquals(Arrays.asList(names), (Object)Tools.list((Iterable)test.getQN()));
        Assert.assertEquals((String)name, (String)test.getRawName());
        Assert.assertEquals((String)extension, (String)test.getExt());
    }

    private void assertPath(boolean absolute, String[] names, String name, String extension, String test) {
        this.assertPath(absolute, names, name, extension, Path.parse((String)test));
    }
}

