/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.request.spi.ActionBridge;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRequestBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockActionBridge
extends MockRequestBridge
implements ActionBridge {
    private Response response;

    public MockActionBridge(MockClient client, String methodId, Map<String, String[]> parameters) {
        super(client, methodId, parameters);
    }

    public String assertUpdate() {
        if (this.response instanceof Response.Update) {
            Response.Update update = (Response.Update)this.response;
            return this.renderURL(Phase.RENDER, update.getParameters(), update.getProperties());
        }
        throw AbstractTestCase.failure("Was expecting an update instead of " + this.response);
    }

    public void assertNoResponse() {
        this.assertResponse(null);
    }

    public void assertRedirect(String location) {
        this.assertResponse((Response)new Response.Redirect(location));
    }

    public void assertRender(String expectedMethodId, Map<String, String> expectedArguments) {
        Response.Update resp = new Response.Update();
        resp.with((PropertyType)RequestContext.METHOD_ID, (Object)expectedMethodId);
        for (Map.Entry<String, String> entry : expectedArguments.entrySet()) {
            resp.setParameter(entry.getKey(), entry.getValue());
        }
        this.assertResponse((Response)resp);
    }

    private void assertResponse(Response expectedResponse) {
        if (expectedResponse instanceof Response.Update) {
            Response.Update expected = (Response.Update)expectedResponse;
            Response.Update resp = (Response.Update)this.response;
            AbstractTestCase.assertEquals((int)expected.getParameters().size(), (int)expected.getParameters().size());
            for (String key : resp.getParameters().keySet()) {
                AbstractTestCase.assertEquals(Arrays.asList((Object[])expected.getParameters().get(key)), Arrays.asList((Object[])resp.getParameters().get(key)));
            }
        } else {
            AbstractTestCase.assertEquals((String)("Was expecting a response " + expectedResponse + " instead of  " + this.response), (Object)expectedResponse, (Object)this.response);
        }
    }

    public void end(Response response) throws IllegalStateException, IOException {
        if (this.response != null) {
            throw new IllegalStateException();
        }
        this.response = response;
    }
}

