/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import juzu.impl.controller.descriptor.ControllerDescriptor;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.Plugin;
import juzu.impl.template.metadata.TemplatesDescriptor;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends Descriptor {
    private final Class<?> applicationClass;
    private final String packageName;
    private final String name;
    private final Class<?> packageClass;
    private final ControllerDescriptor controller;
    private final TemplatesDescriptor templates;
    private final Map<String, Descriptor> plugins;
    private final Map<String, Plugin> foo;

    public ApplicationDescriptor(Class<?> applicationClass) {
        Class<?> packageClass;
        JSON config;
        InputStream in = null;
        try {
            try {
                in = applicationClass.getResourceAsStream("config.json");
                String s = Tools.read(in);
                config = (JSON)JSON.parse(s);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        try {
            packageClass = applicationClass.getClassLoader().loadClass(applicationClass.getPackage().getName() + ".package-info");
        }
        catch (ClassNotFoundException e) {
            AssertionError ae = new AssertionError((Object)"Cannot load package class");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        HashMap<String, Plugin> pluginMap = new HashMap<String, Plugin>();
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            pluginMap.put(plugin.getName(), plugin);
        }
        HashMap<String, Descriptor> pluginDescriptors = new HashMap<String, Descriptor>();
        for (String name : config.names()) {
            Plugin plugin = (Plugin)pluginMap.get(name);
            if (plugin == null) {
                throw new UnsupportedOperationException("Handle me gracefully : missing plugin " + name);
            }
            JSON pluginConfig = config.getJSON(name);
            try {
                Descriptor pluginDescriptor = plugin.init(applicationClass.getClassLoader(), pluginConfig);
                pluginDescriptors.put(name, pluginDescriptor);
            }
            catch (Exception e) {
                AssertionError ae = new AssertionError((Object)"Cannot load config");
                ((Throwable)((Object)ae)).initCause(e);
                throw ae;
            }
        }
        Iterator i = pluginMap.keySet().iterator();
        while (i.hasNext()) {
            String name;
            name = (String)i.next();
            if (pluginDescriptors.containsKey(name)) continue;
            i.remove();
        }
        this.applicationClass = applicationClass;
        this.name = applicationClass.getSimpleName();
        this.packageName = applicationClass.getPackage().getName();
        this.templates = (TemplatesDescriptor)pluginDescriptors.get("template");
        this.packageClass = packageClass;
        this.controller = (ControllerDescriptor)pluginDescriptors.get("controller");
        this.plugins = pluginDescriptors;
        this.foo = pluginMap;
    }

    public Map<String, Plugin> getFoo() {
        return this.foo;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        for (Descriptor descriptor : this.plugins.values()) {
            Tools.addAll(beans, descriptor.getBeans());
        }
        return beans;
    }

    public Descriptor getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void addPlugin(String name, Descriptor plugin) {
        this.plugins.put(name, plugin);
    }

    public Class<?> getPackageClass() {
        return this.packageClass;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public ClassLoader getApplicationLoader() {
        return this.applicationClass.getClassLoader();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public ControllerDescriptor getController() {
        return this.controller;
    }

    public TemplatesDescriptor getTemplates() {
        return this.templates;
    }
}

