/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingTool;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.utils.Content;
import juzu.impl.utils.FQN;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Path;
import juzu.impl.utils.Spliterator;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingContext
implements Filer,
Elements {
    private static final MessageCode UNEXPECTED_ERROR = new MessageCode("UNEXPECTED_ERROR", "Unexpected error: %1$s");
    private static final StandardLocation[] RESOURCE_LOCATIONS = new StandardLocation[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT};
    private ProcessingEnvironment env;
    private static final Logger log = BaseProcessor.getLogger(ProcessingContext.class);
    private final ReadFileSystem<File> sourcePath;
    private final ProcessingTool tool;
    private final ClassLoader serviceCL;
    private Map<ElementHandle<?>, ReadFileSystem<File>> sourcePathMap = new HashMap();

    public ProcessingContext(ProcessingEnvironment env) {
        ProcessingTool tool = env.getMessager().getClass().getName().startsWith("org.eclipse.jdt") ? ProcessingTool.ECLIPSE_IDE : ProcessingTool.JAVAC;
        ClassLoader serviceCL = ProcessingContext.class.getClassLoader();
        DiskFileSystem sourcePath = null;
        try {
            ClassLoader cl = env.getClass().getClassLoader();
            Class<?> eclipseImplClass = cl.loadClass("org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl");
            if (eclipseImplClass.isInstance(env)) {
                File root;
                Spliterator split;
                Method getJavaProject = eclipseImplClass.getMethod("getJavaProject", new Class[0]);
                Object javaProject = getJavaProject.invoke((Object)env, new Object[0]);
                Class<?> aptConfigClass = cl.loadClass("org.eclipse.jdt.apt.core.util.AptConfig");
                Class<?> javaProjectClass = cl.loadClass("org.eclipse.jdt.core.IJavaProject");
                Method getProcessorOptionsMethod = aptConfigClass.getMethod("getProcessorOptions", javaProjectClass);
                Map options = (Map)getProcessorOptionsMethod.invoke(null, javaProject);
                log.log("Retrieved options " + options);
                String sp = (String)options.get("-sourcepath");
                log.log("Found sourcepath " + sp);
                if (sp != null && (split = new Spliterator(sp, ':')).hasNext() && (root = new File(split.next())).isDirectory()) {
                    sourcePath = new DiskFileSystem(root);
                }
                String cp = (String)options.get("-classpath");
                log.log("Found classpath " + cp);
                if (cp != null) {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String s : Spliterator.split(cp, ':')) {
                        File f = new File(s);
                        if (!f.exists() || (!f.isFile() || !f.getName().endsWith(".jar")) && !f.isDirectory()) continue;
                        urls.add(f.toURI().toURL());
                    }
                    serviceCL = new URLClassLoader(urls.toArray(new URL[urls.size()]), serviceCL);
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        log.log("Using processing tool " + (Object)((Object)tool));
        log.log("Using processing " + env);
        log.log("Using source path " + sourcePath);
        this.env = env;
        this.sourcePath = sourcePath;
        this.tool = tool;
        this.serviceCL = serviceCL;
    }

    public void report(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        this.tool.report(this.env.getMessager(), kind, msg, e, a, v);
    }

    public ProcessingEnvironment getEnv() {
        return this.env;
    }

    public <E extends Element> E get(ElementHandle<E> handle) {
        return handle.get(this.env);
    }

    public <T> T executeWithin(ElementHandle element, Callable<T> callable) throws CompilationException {
        return this.executeWithin((Element)element.get(this.env), callable);
    }

    public <T> T executeWithin(Element element, Callable<T> callable) throws CompilationException {
        try {
            return callable.call();
        }
        catch (CompilationException e) {
            if (e.getElement() != null) {
                throw e;
            }
            throw new CompilationException(element, null, e.getMessages()).initCause(e);
        }
        catch (Exception e) {
            throw new CompilationException(element, UNEXPECTED_ERROR, e.getMessage()).initCause(e);
        }
    }

    private ReadFileSystem<File> getSourcePath(ElementHandle.Package context) throws IllegalArgumentException {
        DiskFileSystem sourcePath;
        block9: {
            PackageElement element = (PackageElement)context.get(this.env);
            if (element == null) {
                throw new IllegalArgumentException("Package element cannot be resolved " + context);
            }
            if (this.sourcePath != null) {
                log.log("Found eclipse source path " + this.sourcePath + " for package " + context.getQN());
                return this.sourcePath;
            }
            sourcePath = this.sourcePathMap.get(context);
            if (sourcePath == null) {
                try {
                    log.log("Trying to find a native file system for package " + context.getQN());
                    List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
                    if (annotations.size() > 0) {
                        log.log("Found package " + context.getQN() + " annotations " + annotations + " will use first one");
                        AnnotationMirror annotation = annotations.get(0);
                        ClassLoader cl = this.env.getClass().getClassLoader();
                        Class<?> treesClass = cl.loadClass("com.sun.source.util.Trees");
                        Method instanceMethod = treesClass.getMethod("instance", ProcessingEnvironment.class);
                        Method getPathMethod = treesClass.getMethod("getPath", Element.class, AnnotationMirror.class);
                        Object trees = instanceMethod.invoke(null, this.env);
                        Object path = getPathMethod.invoke(trees, element, annotation);
                        Method getCompilationUnitMethod = path.getClass().getMethod("getCompilationUnit", new Class[0]);
                        Object cu = getCompilationUnitMethod.invoke(path, new Object[0]);
                        Method getSourceFileMethod = cu.getClass().getMethod("getSourceFile", new Class[0]);
                        JavaFileObject file = (JavaFileObject)getSourceFileMethod.invoke(cu, new Object[0]);
                        URI uri = file.toUri();
                        log.log("Resolved uri " + uri + " for package " + context.getQN());
                        File f = new File(uri.getPath());
                        if (f.exists() && f.isFile()) {
                            File dir = f.getParentFile().getParentFile();
                            Name name = element.getQualifiedName();
                            for (int i = 0; i < name.length(); ++i) {
                                if (name.charAt(i) != '.') continue;
                                dir = dir.getParentFile();
                            }
                            sourcePath = new DiskFileSystem(dir);
                            this.sourcePathMap.put(context, sourcePath);
                        }
                        break block9;
                    }
                    log.log("Package " + context.getQN() + " is not annotated (does not make sense)");
                }
                catch (Exception e) {
                    log.log("Could not resolve package " + context, e);
                }
            } else {
                log.log("Found cached source path " + ((SimpleFileSystem)sourcePath).getDescription() + " for package " + context.getQN());
            }
        }
        return sourcePath;
    }

    public Content resolveResource(ElementHandle.Package context, Path.Absolute path) throws NullPointerException, IllegalArgumentException {
        if (context == null) {
            throw new NullPointerException("No null package accepted");
        }
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        ReadFileSystem<File> sourcePath = this.getSourcePath(context);
        if (sourcePath != null) {
            log.log("Attempt to resolve " + path.getCanonical() + " from source path");
            try {
                ArrayList<String> list = new ArrayList<String>();
                Spliterator.split(path.getQN().getValue(), '.', list);
                list.add(path.getName());
                File f = sourcePath.getPath(list);
                if (f != null) {
                    log.log("Resolved " + path + " to " + f.getAbsolutePath());
                    return sourcePath.getContent(f);
                }
                log.log("Resolving " + path.getCanonical() + " from source path gave no result");
            }
            catch (IOException e) {
                log.log("Could not resolve " + path.getCanonical() + " from source path", e);
            }
        } else {
            for (StandardLocation location : RESOURCE_LOCATIONS) {
                try {
                    log.log("Attempt to resolve " + path.getCanonical() + " from " + location.getName());
                    FileObject resource = this.getResource(location, path);
                    byte[] bytes = Tools.bytes(resource.openInputStream());
                    return new Content(resource.getLastModified(), bytes, Charset.defaultCharset());
                }
                catch (Exception e) {
                    log.log("Could not resolve resource " + path.getCanonical() + " from " + location.getName(), e);
                }
            }
        }
        return null;
    }

    public <S> Iterable<S> loadServices(Class<S> service) throws NullPointerException {
        if (service == null) {
            throw new NullPointerException("No null service class accepted");
        }
        log.log("Loading services implementation of " + service.getName());
        try {
            return Tools.list(ServiceLoader.load(service, this.serviceCL));
        }
        catch (ServiceConfigurationError e) {
            log.log("Could not load service for service " + service.getName(), e);
            return Collections.emptyList();
        }
    }

    public Element asElement(TypeMirror t) {
        return this.env.getTypeUtils().asElement(t);
    }

    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isSameType(t1, t2);
    }

    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isSubtype(t1, t2);
    }

    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isAssignable(t1, t2);
    }

    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().contains(t1, t2);
    }

    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.env.getTypeUtils().isSubsignature(m1, m2);
    }

    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.env.getTypeUtils().directSupertypes(t);
    }

    public TypeMirror erasure(TypeMirror t) {
        return this.env.getTypeUtils().erasure(t);
    }

    public TypeElement boxedClass(PrimitiveType p) {
        return this.env.getTypeUtils().boxedClass(p);
    }

    public PrimitiveType unboxedType(TypeMirror t) {
        return this.env.getTypeUtils().unboxedType(t);
    }

    public TypeMirror capture(TypeMirror t) {
        return this.env.getTypeUtils().capture(t);
    }

    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.env.getTypeUtils().getPrimitiveType(kind);
    }

    public NullType getNullType() {
        return this.env.getTypeUtils().getNullType();
    }

    public NoType getNoType(TypeKind kind) {
        return this.env.getTypeUtils().getNoType(kind);
    }

    public ArrayType getArrayType(TypeMirror componentType) {
        return this.env.getTypeUtils().getArrayType(componentType);
    }

    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.env.getTypeUtils().getWildcardType(extendsBound, superBound);
    }

    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.env.getTypeUtils().getDeclaredType(typeElem, typeArgs);
    }

    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.env.getTypeUtils().getDeclaredType(containing, typeElem, typeArgs);
    }

    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.env.getTypeUtils().asMemberOf(containing, element);
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.env.getElementUtils().getPackageElement(name);
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.env.getElementUtils().getTypeElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.env.getElementUtils().getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.env.getElementUtils().getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.env.getElementUtils().isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.env.getElementUtils().getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.env.getElementUtils().getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.env.getElementUtils().getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.env.getElementUtils().getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.env.getElementUtils().hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.env.getElementUtils().overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.env.getElementUtils().getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.env.getElementUtils().printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.env.getElementUtils().getName(cs);
    }

    public JavaFileObject createSourceFile(FQN name, Element ... originatingElements) throws IOException {
        return this.createSourceFile(name.getName(), originatingElements);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        log.log("Creating source file for name=" + name + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createSourceFile(name, originatingElements);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        log.log("Creating class file for name=" + name + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createClassFile(name, originatingElements);
    }

    public FileObject createResource(JavaFileManager.Location location, Path.Absolute path, Element ... originatingElements) throws IOException {
        return this.createResource(location, path.getQN().getValue(), path.getName(), originatingElements);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        log.log("Creating resource file for location=" + location + " pkg=" + pkg + " relativeName=" + relativeName + " elements=" + Arrays.asList(originatingElements));
        return this.env.getFiler().createResource(location, pkg, relativeName, originatingElements);
    }

    public FileObject getResource(JavaFileManager.Location location, Path path) throws IOException {
        return this.getResource(location, path.getQN().getValue(), path.getName());
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        return this.env.getFiler().getResource(location, pkg, relativeName);
    }
}

